/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import waba.io.Catalog;
import waba.io.DataStream;
import waba.io.ResizeStream;

public class FileIO {
    MessageDialog msgDlg;
    private static final String CREATOR_ID = "F100";
    private static final String typeC = "F100";

    public FileIO(MessageDialog messageDialog) {
        this.msgDlg = messageDialog;
    }

    public FileIO() {
    }

    public String readFile(String string) {
        File file = null;
        FileReader fileReader = null;
        String string2 = new String();
        file = new File(string);
        if (!file.exists()) {
            return string2;
        }
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            new ErrorMsg("Error openning file", this.msgDlg);
        }
        if (fileReader == null) {
            return string2;
        }
        char[] cArray = new char[(int)file.length()];
        try {
            fileReader.read(cArray, 0, (int)file.length());
            fileReader.close();
        }
        catch (IOException iOException) {
            new ErrorMsg("Error reading file", this.msgDlg);
            return string2;
        }
        string2 = new String(cArray);
        return string2;
    }

    public boolean writeFile(String string, String string2) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string, false);
        }
        catch (IOException iOException) {
            new ErrorMsg("Error openning file", this.msgDlg);
            return false;
        }
        if (fileWriter == null) {
            return false;
        }
        try {
            fileWriter.write(string2, 0, string2.length());
            fileWriter.close();
        }
        catch (IOException iOException) {
            new ErrorMsg("Error writing file", this.msgDlg);
            return false;
        }
        return true;
    }

    public Properties loadProperties(String string) {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return properties;
        }
        try {
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            new ErrorMsg("Error reading properties file", this.msgDlg);
            return new Properties();
        }
        return properties;
    }

    private String createCatalogName(String string) {
        String string2 = String.valueOf(string) + '.' + "F100" + '.' + "F100";
        return string2;
    }

    public String readCatFile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        System.err.println(string);
        if (string == null || string.length() < 1) {
            return stringBuffer.toString();
        }
        String string2 = this.createCatalogName(string);
        Catalog catalog = new Catalog(string2, 1);
        if (!catalog.isOpen()) {
            return stringBuffer.toString();
        }
        ResizeStream resizeStream = new ResizeStream(catalog, 80);
        DataStream dataStream = new DataStream(resizeStream);
        int n = 0;
        while (n < catalog.getRecordCount()) {
            catalog.setRecordPos(n);
            if (n + 1 == catalog.getRecordCount()) {
                stringBuffer.append(dataStream.readString());
            } else {
                stringBuffer.append(String.valueOf(dataStream.readString()) + "\n");
            }
            ++n;
        }
        catalog.close();
        return stringBuffer.toString();
    }

    public boolean writeCatFile(String string, String string2) {
        if (string == null || string.length() < 1) {
            return false;
        }
        String string3 = this.createCatalogName(string);
        Catalog catalog = new Catalog(string3, 4);
        if (!catalog.isOpen()) {
            return false;
        }
        ResizeStream resizeStream = new ResizeStream(catalog, 80);
        DataStream dataStream = new DataStream(resizeStream);
        Vector vector = this.splitLines(string2);
        int n = 0;
        while (n < vector.size()) {
            resizeStream.startRecord(n);
            dataStream.writeString((String)vector.elementAt(n));
            resizeStream.endRecord();
            ++n;
        }
        catalog.close();
        return true;
    }

    public boolean saveProperties(String string, Properties properties) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            properties.save(fileOutputStream, "---No Comment---");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            new ErrorMsg("Error saving properties file", this.msgDlg);
            return false;
        }
        return true;
    }

    private Vector splitLines(String string) {
        Vector<String> vector = new Vector<String>();
        if (string == null) {
            return vector;
        }
        StrToken strToken = new StrToken(string, "\n\r", true);
        int n = 0;
        String string2 = null;
        String string3 = null;
        while (strToken.hasMoreTokens()) {
            string2 = string3;
            string3 = strToken.nextToken();
            if (string3.equals("\r") && strToken.hasMoreTokens()) {
                string3 = strToken.nextToken();
            }
            if (string3.equals("\n") && string2 != null) {
                if (!string2.equals("\n")) continue;
                vector.addElement("");
                ++n;
                continue;
            }
            vector.addElement(string3);
            ++n;
        }
        return vector;
    }

    public static String isValidCatName(String string) {
        int n = string.indexOf(".pdb");
        if (n < 1) {
            return null;
        }
        String string2 = string.substring(0, n);
        if (string2.indexOf(".") > -1) {
            return null;
        }
        return string2;
    }
}

