/*
 * Decompiled with CFR 0.152.
 */
package waba.io;

import waba.io.Stream;
import waba.sys.Convert;
import waba.sys.Vm;

public class DataStream
extends Stream {
    protected Stream stream;
    protected byte[] b = new byte[4];
    private static byte[] bytes = new byte[128];

    public DataStream(Stream stream) {
        this.stream = stream;
    }

    public boolean close() {
        if (this.stream != null) {
            return this.stream.close();
        }
        return true;
    }

    public final int pad(int n) {
        if (bytes.length < n) {
            bytes = new byte[n + 16];
        }
        int n2 = 0;
        while (n2 < n) {
            DataStream.bytes[n2] = 0;
            ++n2;
        }
        this.writeBytes(bytes, 0, n);
        return n;
    }

    public final void skip(int n) {
        byte[] byArray = new byte[n];
        this.stream.readBytes(byArray, 0, n);
    }

    public final boolean readBoolean() {
        this.stream.readBytes(this.b, 0, 1);
        return this.b[0] != 0;
    }

    public final byte readByte() {
        this.stream.readBytes(this.b, 0, 1);
        return this.b[0];
    }

    public final int readBytes(byte[] byArray, int n, int n2) {
        return this.stream.readBytes(byArray, n, n2);
    }

    public final int readBytes(byte[] byArray) {
        return this.stream.readBytes(byArray, 0, byArray.length);
    }

    public final float readFloat() {
        return Convert.toFloatBitwise(this.readInt());
    }

    public final int readIntLE() {
        this.stream.readBytes(this.b, 0, 4);
        return (this.b[3] & 0xFF) << 24 | (this.b[2] & 0xFF) << 16 | (this.b[1] & 0xFF) << 8 | this.b[0] & 0xFF;
    }

    public final short readShortLE() {
        this.stream.readBytes(this.b, 0, 2);
        return (short)((this.b[1] & 0xFF) << 8 | this.b[0] & 0xFF);
    }

    public final int readInt() {
        this.stream.readBytes(this.b, 0, 4);
        return (this.b[0] & 0xFF) << 24 | (this.b[1] & 0xFF) << 16 | (this.b[2] & 0xFF) << 8 | this.b[3] & 0xFF;
    }

    public final short readShort() {
        return (short)this.readUnsignedShort();
    }

    public final double readDouble() {
        return Convert.longBitsToDouble(this.readLong());
    }

    public final long readLong() {
        long l = this.readInt();
        long l2 = this.readInt();
        long l3 = (l << 32) + l2;
        if (l2 < 0L) {
            l3 += 0x100000000L;
        }
        return l3;
    }

    public final int readUnsignedByte() {
        this.stream.readBytes(this.b, 0, 1);
        return this.b[0] & 0xFF;
    }

    public final int readUnsignedShort() {
        this.stream.readBytes(this.b, 0, 2);
        return (this.b[0] & 0xFF) << 8 | this.b[1] & 0xFF;
    }

    public final int writeIntLE(int n) {
        this.b[0] = (byte)(n & 0xFF);
        this.b[1] = (byte)((n >>= 8) & 0xFF);
        this.b[2] = (byte)((n >>= 8) & 0xFF);
        this.b[3] = (byte)((n >>= 8) & 0xFF);
        this.stream.writeBytes(this.b, 0, 4);
        return 4;
    }

    public final int writeShortLE(int n) {
        this.b[0] = (byte)(n & 0xFF);
        this.b[1] = (byte)((n >>= 8) & 0xFF);
        this.stream.writeBytes(this.b, 0, 2);
        return 2;
    }

    public final int writeBoolean(boolean bl) {
        this.b[0] = bl ? (byte)1 : 0;
        this.stream.writeBytes(this.b, 0, 1);
        return 1;
    }

    public final int writeByte(byte by) {
        this.b[0] = by;
        this.stream.writeBytes(this.b, 0, 1);
        return 1;
    }

    public final int writeByte(int n) {
        this.b[0] = (byte)(n & 0xFF);
        this.stream.writeBytes(this.b, 0, 1);
        return 1;
    }

    public final int writeBytes(byte[] byArray, int n, int n2) {
        return this.stream.writeBytes(byArray, n, n2);
    }

    public final int writeBytes(byte[] byArray) {
        return this.stream.writeBytes(byArray, 0, byArray.length);
    }

    public final int writeFloat(float f) {
        this.writeInt(Convert.toIntBitwise(f));
        return 4;
    }

    public final int writeInt(int n) {
        this.b[3] = (byte)(n & 0xFF);
        this.b[2] = (byte)((n >>= 8) & 0xFF);
        this.b[1] = (byte)((n >>= 8) & 0xFF);
        this.b[0] = (byte)((n >>= 8) & 0xFF);
        this.stream.writeBytes(this.b, 0, 4);
        return 4;
    }

    public final int writeShort(int n) {
        this.b[1] = (byte)(n & 0xFF);
        this.b[0] = (byte)((n >>= 8) & 0xFF);
        this.stream.writeBytes(this.b, 0, 2);
        return 2;
    }

    public final String readString() {
        short s = this.readShort();
        if (s == 0) {
            return "";
        }
        if (bytes.length < s) {
            bytes = new byte[s + 16];
        }
        this.readBytes(bytes, 0, s);
        return new String(bytes, 0, (int)s);
    }

    public final String[] readStringArray() {
        int n = this.readShort();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.readString();
            ++n2;
        }
        return stringArray;
    }

    public final int writeString(String string) {
        int n = 0;
        if (string != null && string.length() > 0) {
            byte[] byArray = string.getBytes();
            n += this.writeShort((short)byArray.length);
            n += this.writeBytes(byArray, 0, byArray.length);
        } else {
            n += this.writeShort(0);
        }
        return n;
    }

    public final int writeStringArray(String[] stringArray) {
        int n = 0;
        if (stringArray == null || stringArray.length == 0) {
            n += this.writeShort(0);
        } else {
            n += this.writeShort((short)stringArray.length);
            int n2 = 0;
            while (n2 < stringArray.length) {
                n += this.writeString(stringArray[n2]);
                ++n2;
            }
        }
        return n;
    }

    public final int writeDouble(double d) {
        return this.writeLong(Convert.doubleToLongBits(d));
    }

    public final int writeLong(long l) {
        this.writeInt((int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL));
        this.writeInt((int)(l & 0xFFFFFFFFFFFFFFFFL));
        return 8;
    }

    public String readCString() {
        int n = 0;
        while (true) {
            this.stream.readBytes(this.b, 0, 1);
            if (this.b[0] == 0) break;
            if (n == bytes.length) {
                byte[] byArray = new byte[bytes.length + 16];
                Vm.copyArray(bytes, 0, byArray, 0, n);
                bytes = byArray;
            }
            DataStream.bytes[n++] = this.b[0];
        }
        return new String(bytes, 0, n);
    }

    public final int writeCString(String string) {
        if (string == null) {
            return this.writeByte(0);
        }
        int n = 0;
        byte[] byArray = string.getBytes();
        n += this.writeBytes(byArray, 0, byArray.length);
        return n += this.writeByte(0);
    }
}

