/*
 * Decompiled with CFR 0.152.
 */
package javax.comm;

import Serialio.SerialPortLocal;
import java.io.IOException;
import java.util.TooManyListenersException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;

public class SerialPortEventTask
extends Thread
implements SerialPortEventListener {
    protected SerialPortEventListener speListener;
    protected SerialPortLocal jsp;
    protected SerialPort spx;
    private EventWatch evWatch;
    private boolean abortTask;
    private boolean abortTaskDone;
    private boolean done;
    private boolean paused;
    private boolean pauseTask;
    int period = 10;
    SerialPortEvent se;

    public SerialPortEventTask(SerialPort serialPort, SerialPortLocal serialPortLocal) {
        this.jsp = serialPortLocal;
        this.spx = serialPort;
        this.evWatch = new EventWatch();
        this.abortTaskDone = false;
        this.abortTask = false;
        this.done = false;
        this.pauseTask = false;
        this.paused = false;
    }

    public void setWatchEvent(int n, boolean bl) {
        int n2 = 0;
        while (n2 < this.evWatch.length) {
            if (this.evWatch.type[n2] == n) {
                if (this.evWatch.isSupported[n2]) {
                    this.evWatch.notify[n2] = bl;
                } else {
                    String string = "Unsupported event type: " + this.evWatch.evNames[n2] + ": Some notifyOnXXX methods SHOULD be defined to throw UnsupportedCommOperationException (this is a javax.comm design flaw)";
                    System.out.println(string);
                }
            }
            ++n2;
        }
    }

    public void addEventListener(SerialPortEventListener serialPortEventListener) throws TooManyListenersException {
        if (this.speListener != null) {
            throw new TooManyListenersException("Sun limits listeners to one");
        }
        this.speListener = serialPortEventListener;
    }

    public void removeEventListener() {
        this.speListener = null;
    }

    public void serialEvent(SerialPortEvent serialPortEvent) {
        System.out.println("SerialPortEventTask: no registered listeners");
    }

    public void setCheckPeriod(int n) {
        this.period = n;
    }

    public void waitPause(int n) throws IOException {
        long l;
        long l2 = l = System.currentTimeMillis();
        long l3 = l + (long)n;
        int n2 = 50;
        this.begPause();
        while (l2 < l3) {
            if (this.paused) {
                return;
            }
            try {
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l2 = System.currentTimeMillis();
        }
        throw new IOException(this.getClass().getName() + ": Task not paused before timeout");
    }

    public void begPause() {
        this.pauseTask = true;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void endPause() {
        this.pauseTask = false;
        SerialPortEventTask serialPortEventTask = this;
        synchronized (serialPortEventTask) {
            this.notify();
        }
    }

    public void run() {
        while (!this.jsp.isOpen()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        while (!this.abortTask) {
            try {
                if (this.speListener != null) {
                    try {
                        int n = this.evWatch.length;
                        int n2 = 0;
                        while (n2 < n) {
                            if (this.evWatch.notify[n2] && this.evWatch.isEvent(n2)) {
                                this.se = new SerialPortEvent(this.spx, this.evWatch.type[n2], this.evWatch.valPrev[n2], this.evWatch.eVal);
                                this.speListener.serialEvent(this.se);
                                this.evWatch.valPrev[n2] = this.evWatch.eVal;
                            }
                            ++n2;
                        }
                    }
                    catch (IOException iOException) {
                        if (!this.abortTask && !this.pauseTask && this.jsp.isOpen()) {
                            iOException.printStackTrace();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (this.pauseTask) {
                    this.doPause();
                }
                Thread.sleep(this.period);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.waitDone(true);
    }

    private void doPause() {
        SerialPortEventTask serialPortEventTask = this;
        synchronized (serialPortEventTask) {
            try {
                this.paused = true;
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.paused = false;
        }
    }

    public void abort() {
        this.abortTask = true;
        this.interrupt();
    }

    public synchronized void waitDone(boolean bl) {
        if (bl) {
            this.notifyAll();
            return;
        }
        try {
            if (!this.abortTaskDone) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class EventWatch {
        protected int[] type = new int[]{6, 3, 4, 5, 10, 9, 7, 8, 1, 2};
        protected boolean[] isSupported = new boolean[this.type.length];
        protected String[] evNames = new String[]{"sigCD", "sigCTS", "sigDSR", "sigRing", "sigBreak", "sigFrameErr", "sigOverrun", "sigParityErr", "rxReadyCount", "txBufCount"};
        protected int length = 10;
        protected boolean[] notify = new boolean[this.length];
        protected boolean[] valPrev = new boolean[this.length];
        boolean eVal;
        boolean sendSinceTxBufEmpty;
        boolean readSinceRxBufCheck;
        int cnt;
        int prevTxQue = 0;
        int prevRxQue = 0;

        protected EventWatch() {
            int n = 0;
            while (n < this.length) {
                this.notify[n] = false;
                this.isSupported[n] = true;
                ++n;
            }
            int n2 = 0;
            while (n2 < this.evNames.length) {
                if (!SerialPortEventTask.this.jsp.isSupported(this.evNames[n2])) {
                    this.isSupported[n2] = false;
                }
                ++n2;
            }
        }

        protected boolean isEvent(int n) throws IOException {
            switch (n) {
                case 0: {
                    this.eVal = SerialPortEventTask.this.jsp.sigCD();
                    return this.eVal != this.valPrev[n];
                }
                case 1: {
                    this.eVal = SerialPortEventTask.this.jsp.sigCTS();
                    return this.eVal != this.valPrev[n];
                }
                case 2: {
                    this.eVal = SerialPortEventTask.this.jsp.sigDSR();
                    return this.eVal != this.valPrev[n];
                }
                case 3: {
                    this.eVal = SerialPortEventTask.this.jsp.sigRing();
                    return this.eVal != this.valPrev[n];
                }
                case 4: {
                    return SerialPortEventTask.this.jsp.sigBreak();
                }
                case 5: {
                    return SerialPortEventTask.this.jsp.sigFrameErr();
                }
                case 6: {
                    return SerialPortEventTask.this.jsp.sigOverrun();
                }
                case 7: {
                    return SerialPortEventTask.this.jsp.sigParityErr();
                }
                case 8: {
                    this.readSinceRxBufCheck = SerialPortEventTask.this.jsp.readSinceRxBufCheck();
                    this.cnt = SerialPortEventTask.this.jsp.rxReadyCount();
                    if (this.cnt != this.prevRxQue || this.readSinceRxBufCheck) {
                        this.prevRxQue = this.cnt;
                        this.eVal = false;
                        SerialPortEventTask.this.jsp.clearReadSinceRxBufCheck();
                        this.readSinceRxBufCheck = false;
                        if (this.cnt > 0) {
                            return true;
                        }
                    }
                    return false;
                }
                case 9: {
                    this.sendSinceTxBufEmpty |= SerialPortEventTask.this.jsp.sendSinceTxBufEmpty();
                    this.cnt = SerialPortEventTask.this.jsp.txBufCount();
                    if (this.cnt == 0 && this.sendSinceTxBufEmpty) {
                        this.eVal = false;
                        SerialPortEventTask.this.jsp.clearSendSinceTxBufEmpty();
                        this.sendSinceTxBufEmpty = false;
                        return true;
                    }
                    return false;
                }
            }
            throw new IOException("Invalid event");
        }
    }
}

