/*
 * Decompiled with CFR 0.152.
 */
package javax.comm;

import java.io.FileDescriptor;
import java.util.Enumeration;
import java.util.Vector;
import javax.comm.CommDriver;
import javax.comm.CommPort;
import javax.comm.CommPortOwnershipListener;
import javax.comm.JSPDriver;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.UnsupportedCommOperationException;

public class CommPortIdentifier {
    public static final int PORT_SERIAL = 1;
    public static final int PORT_PARALLEL = 2;
    private String cpoAppName;
    private CommPort cp;
    private boolean isOpen;
    private Vector cpoListenerList;
    private boolean inCallback = false;
    protected String cpName;
    protected int cpType;
    protected CommDriver cpDriver;
    protected static Vector portList = new Vector();
    protected static CommDriver jspDriver = new JSPDriver(portList);

    private CommPortIdentifier(String string, int n, CommDriver commDriver) {
        this.cpName = string;
        this.cpType = n;
        this.cpDriver = commDriver;
        this.cpoListenerList = new Vector();
    }

    public static void addPortName(String string, int n, CommDriver commDriver) {
        CommPortIdentifier commPortIdentifier;
        if (commDriver == null) {
            commDriver = jspDriver;
        }
        Enumeration enumeration = portList.elements();
        while (enumeration.hasMoreElements()) {
            commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
            if (!commPortIdentifier.getName().equalsIgnoreCase(string)) continue;
            portList.removeElement(commPortIdentifier);
        }
        commPortIdentifier = new CommPortIdentifier(string, n, commDriver);
        portList.addElement(commPortIdentifier);
    }

    public static CommPortIdentifier getPortIdentifier(String string) throws NoSuchPortException {
        int n = 0;
        while (n < portList.size()) {
            CommPortIdentifier commPortIdentifier = (CommPortIdentifier)portList.elementAt(n);
            String string2 = commPortIdentifier.getName();
            if (string2.equals(string)) {
                return commPortIdentifier;
            }
            if (string2.length() == string.length() * 2) {
                char[] cArray = string.toCharArray();
                char[] cArray2 = string2.toCharArray();
                int n2 = 0;
                while (n2 < string.length()) {
                    if (cArray[n2] != cArray2[n2]) break;
                    ++n2;
                }
                if (n2 == string.length()) {
                    return commPortIdentifier;
                }
            }
            ++n;
        }
        throw new NoSuchPortException(string + ": not found in port list.");
    }

    public synchronized CommPort open(String string, int n) throws PortInUseException {
        CommPortOwnershipListener commPortOwnershipListener;
        int n2 = 100;
        if (this.isOpen) {
            long l = System.currentTimeMillis();
            long l2 = l + (long)n;
            if (this.cpoListenerList.size() == 0) {
                throw new PortInUseException(this.cpName + " is owned by " + this.cpoAppName, this.cpoAppName);
            }
            int n3 = 0;
            while (n3 < this.cpoListenerList.size()) {
                commPortOwnershipListener = (CommPortOwnershipListener)this.cpoListenerList.elementAt(n3);
                this.inCallback = true;
                commPortOwnershipListener.ownershipChange(3);
                this.inCallback = false;
                ++n3;
            }
            do {
                try {
                    Thread.sleep(n2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.cp.name != null && System.currentTimeMillis() < l2);
            if (this.isOpen) {
                throw new PortInUseException(this.cpName + " is owned by " + this.cpoAppName, this.cpoAppName);
            }
        }
        this.cpoAppName = string + ":" + Thread.currentThread().getName();
        this.cp = this.cpDriver.getCommPort(this.cpName, this.cpType);
        if (this.cp == null) {
            String string2 = "Could not open " + this.cpName + " " + this.cpDriver.getLastErrMsg();
            throw new PortInUseException(string2);
        }
        this.cp.id = this;
        this.cp.name = this.cpName;
        this.isOpen = true;
        int n4 = 0;
        while (n4 < this.cpoListenerList.size()) {
            commPortOwnershipListener = (CommPortOwnershipListener)this.cpoListenerList.elementAt(n4);
            commPortOwnershipListener.ownershipChange(1);
            ++n4;
        }
        return this.cp;
    }

    protected synchronized void closeNotifcation() {
        if (this.inCallback) {
            this.isOpen = false;
            return;
        }
        Thread thread = Thread.currentThread();
        int n = 0;
        while (n < this.cpoListenerList.size()) {
            CommPortOwnershipListener commPortOwnershipListener = (CommPortOwnershipListener)this.cpoListenerList.elementAt(n);
            commPortOwnershipListener.ownershipChange(2);
            ++n;
        }
        this.isOpen = false;
    }

    public String getName() {
        return this.cpName;
    }

    public int getPortType() {
        return this.cpType;
    }

    public static Enumeration getPortIdentifiers() {
        return portList.elements();
    }

    public String getCurrentOwner() {
        if (this.isOpen) {
            return this.cpoAppName;
        }
        return null;
    }

    public boolean isCurrentlyOwned() {
        return this.isOpen;
    }

    public void addPortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        if (this.cpoListenerList.contains(commPortOwnershipListener)) {
            System.out.println("addPortOwnershipListener: lsnr already in list");
            return;
        }
        this.cpoListenerList.addElement(commPortOwnershipListener);
    }

    public void removePortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        boolean bl = this.cpoListenerList.removeElement(commPortOwnershipListener);
        if (!bl) {
            System.out.println("removePortOwnershipListener: lsnr not found");
        }
    }

    public static CommPortIdentifier getPortIdentifier(CommPort commPort) throws NoSuchPortException {
        System.out.println("CommPortIdentifier.getPortIdentifier(CommPort port)");
        System.out.println("Not currently implemented");
        throw new NoSuchPortException("Not currently implemented");
    }

    public CommPort open(FileDescriptor fileDescriptor) throws UnsupportedCommOperationException {
        System.out.println("CommPortIdentifier.open(FileDescriptor fd)");
        System.out.println("Not currently implemented");
        throw new UnsupportedCommOperationException("Not currently implemented");
    }

    static {
        jspDriver.initialize();
    }
}

