/*
 * Decompiled with CFR 0.152.
 */
package javax.comm;

import Serialio.SerInputStream;
import Serialio.SerOutputStream;
import Serialio.SerialConfig;
import Serialio.SerialPortLocal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEventListener;
import javax.comm.SerialPortEventTask;
import javax.comm.UnsupportedCommOperationException;

public class SerialPortImpl
extends SerialPort {
    private SerialConfig cfg = null;
    private SerialPortLocal jsp = null;
    private SerInputStream inpStream = null;
    private boolean softDTR;
    private boolean softRTS;
    private boolean portOpen = false;
    private SerialPortEventTask seTask;
    private String osName = new String(System.getProperty("os.name"));
    private static final int[] bitRate = new int[]{110, 150, 300, 600, 1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200, 230400};
    private static final int[] jspDataBits = new int[]{0, 1, 2, 3};
    private static final int[] jxDataBits = new int[]{5, 6, 7, 8};
    private static final int[] jspStopBits = new int[]{0, 1};
    private static final int[] jxStopBits = new int[]{1, 2};
    private static final int[] jspParity = new int[]{0, 1, 2, 3, 4};
    private static final int[] jxParity = new int[]{0, 1, 2, 3, 4};
    private static final int[] jspFlow = new int[]{0, 1, 2, 3};
    private String rightWayMsg = "The correct thing to do is to throw an UnsupportedCommOperationException however Sun's API does not define this. For source code compatability with Sun's API we can not do it the correct way. You should contact Sun and encourage them to fix their API. (We suggested they do this in early 1998)";

    public SerialPortImpl(String string) throws IOException {
        this.jsp = new SerialPortLocal();
        this.cfg = this.jsp.getConfig();
        this.jsp.setPortName(string);
        this.jsp.open();
        this.inpStream = new SerInputStream((Serialio.SerialPort)this.jsp);
        this.portOpen = true;
        this.name = string;
        if (this.seTask == null) {
            this.seTask = new SerialPortEventTask(this, this.jsp);
            this.seTask.start();
        }
    }

    public int getBaudRate() {
        return bitRate[this.jsp.getBitRate()];
    }

    public int getDataBits() {
        int n = this.jsp.getDataBits();
        int n2 = -1;
        int n3 = 0;
        while (n3 < jspDataBits.length) {
            if (n == jspDataBits[n3]) {
                n2 = jxDataBits[n3];
            }
            ++n3;
        }
        return n2;
    }

    public int getStopBits() {
        int n = this.jsp.getStopBits();
        int n2 = -1;
        int n3 = 0;
        while (n3 < jspStopBits.length) {
            if (n == jspStopBits[n3]) {
                n2 = jxStopBits[n3];
            }
            ++n3;
        }
        return n2;
    }

    public int getParity() {
        int n = this.jsp.getParity();
        int n2 = -1;
        int n3 = 0;
        while (n3 < jspParity.length) {
            if (n == jspParity[n3]) {
                n2 = jxParity[n3];
            }
            ++n3;
        }
        return n2;
    }

    public int getFlowControlMode() {
        boolean bl = true;
        int n = this.jsp.getHandshake();
        int n2 = 0;
        if (bl) {
            if ((n & 0x40) == 64) {
                n2 |= 4;
            }
            if ((n & 0x80) == 128) {
                n2 |= 8;
            }
            if ((n & 0x10) == 16) {
                n2 |= 1;
            }
            if ((n & 0x20) == 32) {
                n2 |= 2;
            }
        } else {
            int n3 = 12;
            int n4 = 12;
            n2 = n == 0 ? 0 : (n == 1 ? n3 : n4);
        }
        return n2;
    }

    public void setFlowControlMode(int n) throws UnsupportedCommOperationException {
        boolean bl = true;
        if (bl) {
            int n2 = 0;
            if ((n & 4) == 4) {
                n2 |= 0x40;
            }
            if ((n & 8) == 8) {
                n2 |= 0x80;
            }
            if ((n & 1) == 1) {
                n2 |= 0x10;
            }
            if ((n & 2) == 2) {
                n2 |= 0x20;
            }
            this.jsp.setHandshake(n2);
        } else {
            int n3 = 1;
            int n4 = 2;
            int n5 = 4;
            int n6 = 8;
            if (n == 0) {
                this.jsp.setHandshake(0);
            } else if ((n & n5) == n5 || (n & n6) == n6) {
                this.jsp.setHandshake(1);
            } else if ((n & n3) == n3 || (n & n4) == n4) {
                this.jsp.setHandshake(2);
            } else {
                throw new UnsupportedCommOperationException("FlowControl not supported: " + n);
            }
        }
        this.reOpen();
    }

    public void sendBreak(int n) {
        try {
            this.jsp.sendBreak(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException("sendBreak failed");
        }
    }

    public void setSerialPortParams(int n, int n2, int n3, int n4) throws UnsupportedCommOperationException {
        boolean bl = false;
        int n5 = 0;
        while (n5 < bitRate.length) {
            if (n == bitRate[n5]) {
                this.jsp.setBitRate(n5);
                bl = true;
            }
            ++n5;
        }
        if (!bl) {
            throw new UnsupportedCommOperationException("Unsupported bitrate");
        }
        bl = false;
        int n6 = 0;
        while (n6 < jxDataBits.length) {
            if (n2 == jxDataBits[n6]) {
                this.jsp.setDataBits(jspDataBits[n6]);
                bl = true;
            }
            ++n6;
        }
        if (!bl) {
            throw new UnsupportedCommOperationException("Unsupported dataBits");
        }
        bl = false;
        int n7 = 0;
        while (n7 < jxStopBits.length) {
            if (n3 == jxStopBits[n7]) {
                this.jsp.setStopBits(jspStopBits[n7]);
                bl = true;
            }
            ++n7;
        }
        if (!bl) {
            throw new UnsupportedCommOperationException("Unsupported stopBits");
        }
        bl = false;
        int n8 = 0;
        while (n8 < jxParity.length) {
            if (n4 == jxParity[n8]) {
                this.jsp.setParity(jspParity[n8]);
                bl = true;
            }
            ++n8;
        }
        if (!bl) {
            throw new UnsupportedCommOperationException("Unsupported parity");
        }
        this.reOpen();
    }

    public void setDTR(boolean bl) {
        this.softDTR = bl;
        if (!this.jsp.isSupported("setDTR")) {
            String string = "Warning: setting DTR is not supported on this platform. " + this.rightWayMsg;
            System.out.println("eMsg");
            return;
        }
        try {
            this.jsp.setDTR(bl);
        }
        catch (IOException iOException) {
            throw new RuntimeException("setDTR failed");
        }
    }

    public boolean isDTR() {
        return this.softDTR;
    }

    public void setRTS(boolean bl) {
        this.softRTS = bl;
        if (!this.jsp.isSupported("setDTR")) {
            String string = "Warning: setting RTS is not supported on this platform. " + this.rightWayMsg;
            System.out.println("eMsg");
            return;
        }
        try {
            this.jsp.setRTS(bl);
        }
        catch (IOException iOException) {
            throw new RuntimeException("setRTS failed");
        }
    }

    public boolean isRTS() {
        return this.softRTS;
    }

    public boolean isCTS() {
        try {
            return this.jsp.sigCTS();
        }
        catch (IOException iOException) {
            throw new RuntimeException("isCTS failed");
        }
    }

    public boolean isDSR() {
        try {
            return this.jsp.sigDSR();
        }
        catch (IOException iOException) {
            throw new RuntimeException("isDSR failed");
        }
    }

    public boolean isRI() {
        try {
            return this.jsp.sigRing();
        }
        catch (IOException iOException) {
            throw new RuntimeException("isRI failed");
        }
    }

    public boolean isCD() {
        try {
            return this.jsp.sigCD();
        }
        catch (IOException iOException) {
            throw new RuntimeException("isCD failed");
        }
    }

    public void addEventListener(SerialPortEventListener serialPortEventListener) throws TooManyListenersException {
        this.seTask.addEventListener(serialPortEventListener);
    }

    public void removeEventListener() {
        this.seTask.removeEventListener();
    }

    public void notifyOnDataAvailable(boolean bl) {
        this.seTask.setWatchEvent(1, bl);
    }

    public void notifyOnOutputEmpty(boolean bl) {
        this.seTask.setWatchEvent(2, bl);
    }

    public void notifyOnCTS(boolean bl) {
        this.seTask.setWatchEvent(3, bl);
    }

    public void notifyOnDSR(boolean bl) {
        this.seTask.setWatchEvent(4, bl);
    }

    public void notifyOnRingIndicator(boolean bl) {
        this.seTask.setWatchEvent(5, bl);
    }

    public void notifyOnCarrierDetect(boolean bl) {
        this.seTask.setWatchEvent(6, bl);
    }

    public void notifyOnOverrunError(boolean bl) {
        this.seTask.setWatchEvent(7, bl);
    }

    public void notifyOnParityError(boolean bl) {
        this.seTask.setWatchEvent(8, bl);
    }

    public void notifyOnFramingError(boolean bl) {
        this.seTask.setWatchEvent(9, bl);
    }

    public void notifyOnBreakInterrupt(boolean bl) {
        this.seTask.setWatchEvent(10, bl);
    }

    public InputStream getInputStream() throws IOException {
        return this.inpStream;
    }

    public OutputStream getOutputStream() throws IOException {
        SerOutputStream serOutputStream = new SerOutputStream((Serialio.SerialPort)this.jsp);
        return serOutputStream;
    }

    public String getName() {
        return this.jsp.getPortName();
    }

    public void close() {
        if (!this.portOpen) {
            return;
        }
        try {
            this.seTask.abort();
            if (this.osName.equals("EPOC")) {
                int n;
                int n2 = this.jsp.getTimeoutTx();
                int n3 = n = this.jsp.getTimeoutRx();
                if (n2 > n) {
                    n3 = n2;
                }
                this.seTask.join(n3 + 5000);
            }
            this.jsp.close();
            this.seTask = null;
            super.close();
            this.portOpen = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(this.getClass().getName() + ": Close failed: " + exception.getMessage());
        }
    }

    public void setInputBufferSize(int n) {
        this.cfg.setRxLen(n);
        this.reOpen();
    }

    public int getInputBufferSize() {
        return this.cfg.getRxLen();
    }

    public void setOutputBufferSize(int n) {
        this.cfg.setTxLen(n);
        this.reOpen();
    }

    public int getOutputBufferSize() {
        return this.cfg.getTxLen();
    }

    public void reOpen() {
        try {
            boolean bl = this.isDTR();
            this.seTask.begPause();
            if (this.osName.equals("EPOC")) {
                int n;
                int n2 = this.jsp.getTimeoutTx();
                int n3 = n = this.jsp.getTimeoutRx();
                if (n2 > n) {
                    n3 = n2;
                }
                this.seTask.waitPause(n3 + 5000);
            }
            this.jsp.reset();
            this.setDTR(bl);
            this.seTask.endPause();
        }
        catch (Exception exception) {
            throw new RuntimeException("reOpen failed: " + exception.getMessage());
        }
    }

    protected void finalize() {
        this.seTask.abort();
    }

    public String toString() {
        return this.getClass().getName() + "[" + "" + "]";
    }

    public void enableReceiveThreshold(int n) {
        this.inpStream.setRcvThreshold(n);
    }

    public void disableReceiveThreshold() {
        this.inpStream.setRcvThreshold(1);
    }

    public boolean isReceiveThresholdEnabled() {
        return this.inpStream.getRcvThreshold() > 1;
    }

    public int getReceiveThreshold() {
        return this.inpStream.getRcvThreshold();
    }

    public void enableReceiveTimeout(int n) {
        this.inpStream.setRcvTimeout(n);
    }

    public void disableReceiveTimeout() {
        this.inpStream.setRcvTimeout(0);
    }

    public boolean isReceiveTimeoutEnabled() {
        return this.inpStream.getRcvTimeout() > 0;
    }

    public int getReceiveTimeout() {
        return this.inpStream.getRcvTimeout();
    }

    public void enableReceiveFraming(int n) {
        this.inpStream.setRcvFrameChar(n);
    }

    public void disableReceiveFraming() {
        this.inpStream.setRcvFrameChar(-1);
    }

    public boolean isReceiveFramingEnabled() {
        return this.inpStream.getRcvFrameChar() != -1;
    }

    public int getReceiveFramingByte() {
        return this.inpStream.getRcvFrameChar();
    }
}

