/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.rmi.server.UID;

public final class ObjID
implements Serializable {
    private static final long serialVersionUID = -6386392263968365220L;
    public static final int REGISTRY_ID = 0;
    public static final int DGC_ID = 2;
    private long objNum;
    private UID space;
    private static long nextNum;
    private static final UID mySpace;

    public ObjID() {
        UID uID = mySpace;
        synchronized (uID) {
            this.space = mySpace;
            this.objNum = nextNum++;
            return;
        }
    }

    public ObjID(int n) {
        this.space = new UID(0);
        this.objNum = n;
    }

    private ObjID(long l, UID uID) {
        this.objNum = l;
        this.space = uID;
    }

    public void write(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.objNum);
        this.space.write(objectOutput);
    }

    public static ObjID read(ObjectInput objectInput) throws IOException {
        long l = objectInput.readLong();
        UID uID = UID.read(objectInput);
        return new ObjID(l, uID);
    }

    public int hashCode() {
        return (int)this.objNum;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ObjID) {
            ObjID objID = (ObjID)object;
            return this.objNum == objID.objNum && this.space.equals(objID.space);
        }
        return false;
    }

    public String toString() {
        return "[" + (this.space.equals(mySpace) ? "" : String.valueOf(this.space) + ", ") + this.objNum + "]";
    }

    static {
        mySpace = new UID();
    }
}

