/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class GregorianCalendar
extends Calendar {
    public static final int BC = 0;
    public static final int AD = 1;
    private static final long julianDayOffset = 2440588L;
    private static final int millisPerDay = 86400000;
    private static final int[] NUM_DAYS;
    private static final int[] LEAP_NUM_DAYS;
    private static final int[] MONTH_LENGTH;
    private static final int[] LEAP_MONTH_LENGTH;
    private long gregorianCutover = -12219292800000L;
    private static long JULIAN_ONSET;
    private static final long ONE_SECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    static final long serialVersionUID = -8125100834729963327L;
    private static final int[] MinValues;
    private static final int[] GreatestMinValues;
    private static final int[] LeastMaxValues;
    private static final int[] MaxValues;

    private static final long millisToJulianDay(long l) {
        if (l >= 0L) {
            return 2440588L + l / 86400000L;
        }
        return 2440588L + (l - 86400000L + 1L) / 86400000L;
    }

    private static final long julianDayToMillis(long l) {
        return (l - 2440588L) * 86400000L;
    }

    public GregorianCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public GregorianCalendar(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public GregorianCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public GregorianCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public GregorianCalendar(int n, int n2, int n3) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(0, 1);
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(0, 1);
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(0, 1);
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
        this.set(13, n6);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Calendar)) {
            return false;
        }
        Calendar calendar = (Calendar)object;
        return this.getTimeInMillis() == calendar.getTimeInMillis() && this.isLenient() == calendar.isLenient() && this.getFirstDayOfWeek() == calendar.getFirstDayOfWeek() && this.getMinimalDaysInFirstWeek() == calendar.getMinimalDaysInFirstWeek() && this.getTimeZone().equals(calendar.getTimeZone());
    }

    public boolean before(Object object) {
        return object instanceof Calendar && this.getTimeInMillis() < ((Calendar)object).getTimeInMillis();
    }

    public boolean after(Object object) {
        return object instanceof Calendar && this.getTimeInMillis() > ((Calendar)object).getTimeInMillis();
    }

    public void setGregorianChange(Date date) {
        this.gregorianCutover = date.getTime();
    }

    public final Date getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    private static final int julianDayToDayOfWeek(long l) {
        int n;
        return n + ((n = (int)((l + 1L) % 7L)) < 0 ? 8 : 1);
    }

    private final void timeToFields(long l, boolean bl) {
        long l2;
        int n = 1;
        long l3 = GregorianCalendar.millisToJulianDay(l);
        if (l >= this.gregorianCutover) {
            long l4 = (long)(((double)(l3 - 1867216L) - 0.25) / 36524.25);
            l2 = l3 + 1L + l4 - (long)(0.25 * (double)l4);
        } else {
            l2 = l3;
        }
        long l5 = l2 + 1524L;
        long l6 = (long)Math.floor(6680.0 + ((double)(l5 - 2439870L) - 122.1) / 365.25);
        long l7 = (long)Math.floor((double)(365L * l6) + 0.25 * (double)l6);
        long l8 = (long)((double)(l5 - l7) / 30.6001);
        int n2 = (int)(l5 - l7 - (long)(30.6001 * (double)l8));
        int n3 = (int)l8 - 1;
        if (n3 > 12) {
            n3 -= 12;
        }
        int n4 = (int)(l6 - 4715L);
        if (n3 > 2) {
            --n4;
        }
        int n5 = n4;
        if (n4 <= 0) {
            n = 0;
            n5 = 1 - n4;
        }
        this.internalSet(0, n);
        this.internalSet(1, n5);
        this.internalSet(2, n3 - 1);
        this.internalSet(5, n2);
        int n6 = GregorianCalendar.julianDayToDayOfWeek(l3);
        this.internalSet(7, n6);
        int n7 = (this.isLeapYear(n4) ? LEAP_NUM_DAYS[n3 - 1] : NUM_DAYS[n3 - 1]) + n2;
        this.internalSet(6, n7);
        if (bl) {
            return;
        }
        int n8 = (n6 + 7 - this.getFirstDayOfWeek()) % 7;
        int n9 = (n6 - n7 + 701 - this.getFirstDayOfWeek()) % 7;
        int n10 = (n7 - 1 + n9) / 7;
        if (7 - n9 >= this.getMinimalDaysInFirstWeek()) {
            ++n10;
            int n11 = this.yearLength();
            int n12 = (n8 + n11 - n7) % 7;
            if (n12 < 0) {
                n12 += 7;
            }
            if (n7 > 359 && 6 - n12 >= this.getMinimalDaysInFirstWeek() && n7 + 7 - n8 > n11) {
                n10 = 1;
            }
        } else if (n10 == 0) {
            int n13 = n7 + this.yearLength(n4 - 1);
            n10 = this.weekNumber(n13, n6);
        }
        this.internalSet(3, n10);
        this.internalSet(4, this.weekNumber(n2, n6));
        this.internalSet(8, (n2 - 1) / 7 + 1);
    }

    private int weekNumber(int n, int n2) {
        int n3 = (n2 - this.getFirstDayOfWeek() - n + 1) % 7;
        if (n3 < 0) {
            n3 += 7;
        }
        int n4 = (n + n3 - 1) / 7;
        if (7 - n3 >= this.getMinimalDaysInFirstWeek()) {
            ++n4;
        }
        return n4;
    }

    public boolean isLeapYear(int n) {
        long l = (long)((double)(n - 1970) * 365.2422 * 8.64E7);
        if (l < JULIAN_ONSET) {
            return false;
        }
        if (l > this.gregorianCutover) {
            return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
        }
        return n % 4 == 0;
    }

    protected void computeFields() {
        int n;
        int n2 = this.getTimeZone().getRawOffset();
        long l = this.time + (long)n2;
        this.timeToFields(l, false);
        int n3 = this.internalGetEra();
        int n4 = this.internalGet(1);
        int n5 = this.internalGet(2);
        int n6 = this.internalGet(5);
        int n7 = this.internalGet(7);
        long l2 = l / 86400000L;
        int n8 = (int)(l - l2 * 86400000L);
        if (n8 < 0) {
            n8 += 86400000;
        }
        if ((n8 += (n = this.getTimeZone().getOffset(n3, n4, n5, n6, n7, n8) - n2)) >= 86400000) {
            n8 -= 86400000;
            this.timeToFields(l += (long)n, false);
        }
        this.internalSet(14, n8 % 1000);
        this.internalSet(13, (n8 /= 1000) % 60);
        this.internalSet(12, (n8 /= 60) % 60);
        this.internalSet(11, n8 /= 60);
        this.internalSet(9, n8 / 12);
        this.internalSet(10, n8 % 12);
        this.internalSet(15, n2);
        this.internalSet(16, n);
        int n9 = 0;
        while (n9 < 17) {
            this.stamp[n9] = 1;
            ++n9;
        }
        int n10 = 0;
        while (n10 < 17) {
            this.isSet[n10] = true;
            ++n10;
        }
    }

    boolean inDaylightTime() {
        if (!this.getTimeZone().useDaylightTime()) {
            return false;
        }
        this.complete();
        return this.internalGet(16) != 0;
    }

    private final int monthLength(int n, int n2) {
        if (this.isLeapYear(n2)) {
            return LEAP_MONTH_LENGTH[n];
        }
        return MONTH_LENGTH[n];
    }

    private final int monthLength(int n) {
        int n2 = this.internalGet(1);
        if (this.internalGetEra() == 0) {
            n2 = 1 - n2;
        }
        return this.monthLength(n, n2);
    }

    private final int yearLength(int n) {
        if (this.isLeapYear(n)) {
            return 366;
        }
        return 365;
    }

    private final int yearLength() {
        if (this.isLeapYear(this.internalGet(1))) {
            return 366;
        }
        return 365;
    }

    private final void pinDayOfMonth() {
        int n = this.monthLength(this.internalGet(2));
        int n2 = this.internalGet(5);
        if (n2 > n) {
            this.set(5, n);
        }
    }

    private boolean validateFields() {
        int n = 0;
        while (n < 17) {
            if (n != 5 && n != 6 && this.isSet(n) && !this.boundsCheck(this.internalGet(n), n)) {
                return false;
            }
            ++n;
        }
        if (this.isSet(5)) {
            int n2 = this.internalGet(5);
            return n2 >= this.getMinimum(5) && n2 <= this.monthLength(this.internalGet(2));
        }
        if (this.isSet(6)) {
            int n3 = this.internalGet(6);
            if (this.isLeapYear(this.internalGet(1)) ? n3 < 1 || n3 > 366 : n3 < 1 || n3 > 365) {
                return false;
            }
        }
        return !this.isSet(8) || this.internalGet(8) != 0;
    }

    private boolean boundsCheck(int n, int n2) {
        return n >= this.getMinimum(n2) && n <= this.getMaximum(n2);
    }

    private static final int floorDivide(long l, int n, int[] nArray) {
        if (l >= 0L) {
            nArray[0] = (int)(l % (long)n);
            return (int)(l / (long)n);
        }
        int n2 = (int)((l + 1L) / (long)n - 1L);
        nArray[0] = (int)(l - (long)(n2 * n));
        return n2;
    }

    private final int aggregateStamp(int n, int n2) {
        if (n != 0 && n2 != 0) {
            return Math.max(n, n2);
        }
        return 0;
    }

    protected void computeTime() {
        int n;
        long l;
        int n2;
        if (!this.isLenient() && !this.validateFields()) {
            throw new IllegalArgumentException();
        }
        long l2 = 0L;
        int n3 = this.stamp[1] != 0 ? this.internalGet(1) : 1970;
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        if (this.stamp[0] != 0) {
            n6 = this.internalGet(0);
            if (n6 == 0) {
                n3 = 1 - n3;
            } else if (n6 != 1) {
                throw new IllegalArgumentException("Invalid era");
            }
        }
        long l3 = 0L;
        int n7 = this.stamp[7];
        int n8 = this.stamp[2];
        int n9 = this.stamp[5];
        int n10 = this.aggregateStamp(this.stamp[4], n7);
        int n11 = this.aggregateStamp(this.stamp[8], n7);
        int n12 = this.stamp[6];
        int n13 = this.aggregateStamp(this.stamp[3], n7);
        int n14 = n2 = n8 > n9 ? n8 : n9;
        if (n10 > n2) {
            n2 = n10;
        }
        if (n11 > n2) {
            n2 = n11;
        }
        if (n12 > n2) {
            n2 = n12;
        }
        if (n13 > n2) {
            n2 = n13;
        }
        if (n2 != 0 && (n2 == n8 || n2 == n9 || n2 == n10 || n2 == n11)) {
            n4 = (n8 != 0 ? this.internalGet(2) : 0) + 1;
            if (n4 < 1) {
                n3 += n4 / 12 - 1;
                n4 = 12 + n4 % 12;
            } else if (n4 > 12) {
                n3 += n4 / 12;
                n4 %= 12;
            }
            if (n4 > 2) {
                ++n4;
            } else {
                --n3;
                n4 += 13;
            }
            l3 = (long)(Math.floor(365.25 * (double)n3) + Math.floor(30.6001 * (double)n4) + 1720995.0);
            if (n2 == n9 || n2 == n8) {
                n5 = n9 != 0 ? this.internalGet(5) : 1;
            } else {
                l = l3;
                if (GregorianCalendar.julianDayToMillis(l3) >= this.gregorianCutover) {
                    long l4 = (long)(0.01 * (double)n3);
                    l += 2L - l4 + (long)(0.25 * (double)l4);
                }
                if ((n = GregorianCalendar.julianDayToDayOfWeek(l + 1L) - this.getFirstDayOfWeek()) < 0) {
                    n += 7;
                }
                n5 = 1 - n + (this.stamp[7] != 0 ? this.internalGet(7) - this.getFirstDayOfWeek() : 0);
                if (n2 == n10) {
                    if (7 - n < this.getMinimalDaysInFirstWeek()) {
                        n5 += 7;
                    }
                    n5 += 7 * (this.internalGet(4) - 1);
                } else {
                    int n15;
                    if (n5 < 1) {
                        n5 += 7;
                    }
                    n5 = (n15 = this.internalGet(8)) >= 0 ? (n5 += 7 * (n15 - 1)) : (n5 += ((this.monthLength(this.internalGet(2), n3) - n5) / 7 + n15 + 1) * 7);
                }
            }
            l3 += (long)n5;
        } else {
            l3 = (long)(Math.floor(365.25 * (double)(--n3)) + 428.0 + 1720995.0);
            if (n2 == 0) {
                ++l3;
            } else if (n2 == n12) {
                l3 += (long)this.internalGet(6);
            } else if (n2 == n13) {
                l = l3;
                if (GregorianCalendar.julianDayToMillis(l3) >= this.gregorianCutover) {
                    long l5 = (long)(0.01 * (double)n3);
                    l += 2L - l5 + (long)(0.25 * (double)l5);
                }
                if ((n = GregorianCalendar.julianDayToDayOfWeek(l + 1L) - this.getFirstDayOfWeek()) < 0) {
                    n += 7;
                }
                n5 = 1 - n + (this.stamp[7] != 0 ? this.internalGet(7) - this.getFirstDayOfWeek() : 0);
                if (7 - n < this.getMinimalDaysInFirstWeek()) {
                    n5 += 7;
                }
                l3 += (long)(n5 += 7 * (this.internalGet(3) - 1));
            }
        }
        l2 = GregorianCalendar.julianDayToMillis(l3);
        if (l2 >= this.gregorianCutover) {
            l = (long)(0.01 * (double)n3);
            l2 = GregorianCalendar.julianDayToMillis(l3 += 2L - l + (long)(0.25 * (double)l));
        }
        int n16 = 0;
        n = this.stamp[10];
        int n17 = this.stamp[11];
        int n18 = n2 = n > n17 ? n : n17;
        if (n2 != 0) {
            if (n2 == n17) {
                n16 += this.internalGet(11);
            } else {
                n16 += this.internalGet(10);
                n16 += 12 * this.internalGet(9);
            }
        }
        n16 *= 60;
        n16 += this.internalGet(12);
        n16 *= 60;
        n16 += this.internalGet(13);
        n16 *= 1000;
        TimeZone timeZone = this.getTimeZone();
        int n19 = this.stamp[15] >= 2 ? this.internalGet(15) : timeZone.getRawOffset();
        l2 += (long)(n16 += this.internalGet(14));
        int n20 = 0;
        if (this.stamp[15] >= 2) {
            n20 = this.internalGet(16);
        } else {
            int[] nArray = new int[1];
            GregorianCalendar.floorDivide(l2, 86400000, nArray);
            if (this.isLenient() || this.stamp[2] == 0 || this.stamp[5] == 0 || n16 != nArray[0]) {
                this.timeToFields(l2, true);
                int n21 = this.internalGet(7);
                n16 = nArray[0];
            } else {
                int n22 = GregorianCalendar.julianDayToDayOfWeek(l3);
            }
            n20 = timeZone.getOffset(n6, this.internalGet(1), this.internalGet(2), this.internalGet(5), GregorianCalendar.julianDayToDayOfWeek(l3), n16) - n19;
        }
        this.time = l2 - (long)n19 - (long)n20;
    }

    public synchronized int hashCode() {
        return this.getFirstDayOfWeek() ^ this.getMinimalDaysInFirstWeek();
    }

    public void add(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.complete();
        if (n == 1) {
            int n3 = this.internalGet(1);
            if (this.internalGetEra() == 1) {
                if ((n3 += n2) > 0) {
                    this.set(1, n3);
                } else {
                    this.set(1, 1 - n3);
                    this.set(0, 0);
                }
            } else if ((n3 -= n2) > 0) {
                this.set(1, n3);
            } else {
                this.set(1, 1 - n3);
                this.set(0, 1);
            }
            this.pinDayOfMonth();
            return;
        }
        if (n == 2) {
            int n4 = this.internalGet(2) + n2;
            if (n4 >= 0) {
                this.set(1, this.internalGet(1) + n4 / 12);
                this.set(2, n4 % 12);
            } else {
                this.set(1, this.internalGet(1) + (n4 + 1) / 12 - 1);
                if ((n4 %= 12) < 0) {
                    n4 += 12;
                }
                this.set(2, n4);
            }
            this.pinDayOfMonth();
            return;
        }
        if (n == 0) {
            int n5 = this.internalGet(0) + n2;
            if (n5 < 0) {
                n5 = 0;
            }
            if (n5 > 1) {
                n5 = 1;
            }
            this.set(0, n5);
            return;
        }
        long l = this.internalGet(16);
        long l2 = n2;
        switch (n) {
            case 3: 
            case 4: 
            case 8: {
                l2 *= 604800000L;
                break;
            }
            case 9: {
                l2 *= 43200000L;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                l2 *= 86400000L;
                break;
            }
            case 10: 
            case 11: {
                l2 *= 3600000L;
                break;
            }
            case 12: {
                l2 *= 60000L;
                break;
            }
            case 13: {
                l2 *= 1000L;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
            case 14: 
        }
        this.setTimeInMillis(this.time + l2);
        l -= (long)this.internalGet(16);
        if (l2 != 0L) {
            this.setTimeInMillis(this.time + l);
        }
    }

    public void roll(int n, boolean bl) {
        this.roll(n, bl ? 1 : -1);
    }

    void roll(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.complete();
        int n3 = this.getMinimum(n);
        int n4 = this.getMaximum(n);
        switch (n) {
            case 2: {
                int n5 = (this.internalGet(2) + n2) % 12;
                if (n5 < 0) {
                    n5 += 12;
                }
                this.set(2, n5);
                int n6 = this.monthLength(n5);
                int n7 = this.internalGet(5);
                if (n7 > n6) {
                    this.set(5, n6);
                }
                return;
            }
            case 3: {
                int n8 = this.internalGet(3);
                int n9 = this.internalGet(1);
                int n10 = this.internalGet(6);
                if (this.internalGet(2) == 0) {
                    if (n8 >= 52) {
                        n10 += this.yearLength(--n9);
                    }
                } else if (n8 == 1) {
                    n10 -= this.yearLength(n9);
                    ++n9;
                }
                if ((n8 += n2) < 1 || n8 > 52) {
                    int n11 = this.yearLength(n9);
                    int n12 = (n11 - n10 + this.internalGet(7) - this.getFirstDayOfWeek()) % 7;
                    if (n12 < 0) {
                        n12 += 7;
                    }
                    if (6 - n12 >= this.getMinimalDaysInFirstWeek()) {
                        n11 -= 7;
                    }
                    int n13 = this.weekNumber(n11, n12 + 1);
                    n8 = (n8 + n13 - 1) % n13 + 1;
                }
                this.set(3, n8);
                this.set(1, n9);
                return;
            }
            case 4: {
                int n14;
                int n15 = this.internalGet(7) - this.getFirstDayOfWeek();
                if (n15 < 0) {
                    n15 += 7;
                }
                if ((n14 = (n15 - this.internalGet(5) + 1) % 7) < 0) {
                    n14 += 7;
                }
                int n16 = 7 - n14 < this.getMinimalDaysInFirstWeek() ? 8 - n14 : 1 - n14;
                int n17 = this.monthLength(this.internalGet(2));
                int n18 = (n17 - this.internalGet(5) + n15) % 7;
                int n19 = n17 + 7 - n18;
                int n20 = n19 - n16;
                int n21 = (this.internalGet(5) + n2 * 7 - n16) % n20;
                if (n21 < 0) {
                    n21 += n20;
                }
                if ((n21 += n16) < 1) {
                    n21 = 1;
                }
                if (n21 > n17) {
                    n21 = n17;
                }
                this.set(5, n21);
                return;
            }
            case 5: {
                n4 = this.monthLength(this.internalGet(2));
                break;
            }
            case 6: {
                long l = (long)n2 * 86400000L;
                long l2 = this.time - (long)(this.internalGet(6) - 1) * 86400000L;
                int n22 = this.isLeapYear(this.internalGet(1)) ? 366 : 365;
                this.time = (this.time + l - l2) % ((long)n22 * 86400000L);
                if (this.time < 0L) {
                    this.time += (long)n22 * 86400000L;
                }
                this.setTimeInMillis(this.time + l2);
                return;
            }
            case 7: {
                long l = (long)n2 * 86400000L;
                int n23 = this.internalGet(7) - this.getFirstDayOfWeek();
                if (n23 < 0) {
                    n23 += 7;
                }
                long l3 = this.time - (long)n23 * 86400000L;
                this.time = (this.time + l - l3) % 604800000L;
                if (this.time < 0L) {
                    this.time += 604800000L;
                }
                this.setTimeInMillis(this.time + l3);
                return;
            }
            case 8: {
                long l = (long)n2 * 604800000L;
                int n24 = (this.internalGet(5) - 1) / 7;
                int n25 = (this.monthLength(this.internalGet(2)) - this.internalGet(5)) / 7;
                long l4 = this.time - (long)n24 * 604800000L;
                long l5 = 604800000L * (long)(n24 + n25 + 1);
                this.time = (this.time + l - l4) % l5;
                if (this.time < 0L) {
                    this.time += l5;
                }
                this.setTimeInMillis(this.time + l4);
                return;
            }
            default: {
                throw new IllegalArgumentException();
            }
            case 0: 
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
        }
        int n26 = n4 - n3 + 1;
        int n27 = this.internalGet(n) + n2;
        n27 = (n27 - n3) % n26;
        if (n27 < 0) {
            n27 += n26;
        }
        this.set(n, n27 += n3);
    }

    public int getMinimum(int n) {
        return MinValues[n];
    }

    public int getMaximum(int n) {
        return MaxValues[n];
    }

    public int getGreatestMinimum(int n) {
        return GreatestMinValues[n];
    }

    public int getLeastMaximum(int n) {
        return LeastMaxValues[n];
    }

    private final int internalGetEra() {
        if (this.isSet(0)) {
            return this.internalGet(0);
        }
        return 1;
    }

    static {
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        NUM_DAYS = nArray;
        int[] nArray2 = new int[12];
        nArray2[1] = 31;
        nArray2[2] = 60;
        nArray2[3] = 91;
        nArray2[4] = 121;
        nArray2[5] = 152;
        nArray2[6] = 182;
        nArray2[7] = 213;
        nArray2[8] = 244;
        nArray2[9] = 274;
        nArray2[10] = 305;
        nArray2[11] = 335;
        LEAP_NUM_DAYS = nArray2;
        MONTH_LENGTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        LEAP_MONTH_LENGTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        JULIAN_ONSET = -62893584000000L;
        int[] nArray3 = new int[17];
        nArray3[1] = 1;
        nArray3[3] = 1;
        nArray3[5] = 1;
        nArray3[6] = 1;
        nArray3[7] = 1;
        nArray3[8] = -1;
        nArray3[15] = -43200000;
        MinValues = nArray3;
        int[] nArray4 = new int[17];
        nArray4[1] = 1;
        nArray4[3] = 1;
        nArray4[5] = 1;
        nArray4[6] = 1;
        nArray4[7] = 1;
        nArray4[8] = -1;
        nArray4[15] = -43200000;
        GreatestMinValues = nArray4;
        LeastMaxValues = new int[]{1, 5000000, 11, 52, 4, 28, 365, 7, 4, 1, 11, 23, 59, 59, 999, 43200000, 3600000};
        MaxValues = new int[]{1, 5000000, 11, 53, 6, 31, 366, 7, 6, 1, 12, 23, 59, 59, 999, 43200000, 3600000};
    }
}

