/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.VectorEnumerator;

public class Vector
implements Cloneable,
Serializable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = -2767605614048989439L;

    public Vector(int n, int n2) {
        this.elementData = new Object[n];
        this.capacityIncrement = n2;
    }

    public Vector(int n) {
        this(n, 0);
    }

    public Vector() {
        this(10);
    }

    public final synchronized void copyInto(Object[] objectArray) {
        int n = this.elementCount;
        while (n-- > 0) {
            objectArray[n] = this.elementData[n];
        }
    }

    public final synchronized void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int n) {
        if (n > this.elementData.length) {
            this.ensureCapacityHelper(n);
        }
    }

    private void ensureCapacityHelper(int n) {
        int n2;
        int n3 = this.elementData.length;
        Object[] objectArray = this.elementData;
        int n4 = n2 = this.capacityIncrement > 0 ? n3 + this.capacityIncrement : n3 * 2;
        if (n2 < n) {
            n2 = n;
        }
        this.elementData = new Object[n2];
        System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
    }

    public final synchronized void setSize(int n) {
        if (n > this.elementCount && n > this.elementData.length) {
            this.ensureCapacityHelper(n);
        } else {
            int n2 = n;
            while (n2 < this.elementCount) {
                this.elementData[n2] = null;
                ++n2;
            }
        }
        this.elementCount = n;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final synchronized Enumeration elements() {
        return new VectorEnumerator(this);
    }

    public final boolean contains(Object object) {
        return this.indexOf(object, 0) >= 0;
    }

    public final int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public final synchronized int indexOf(Object object, int n) {
        int n2 = n;
        while (n2 < this.elementCount) {
            if (object.equals(this.elementData[n2])) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public final int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public final synchronized int lastIndexOf(Object object, int n) {
        int n2 = n;
        while (n2 >= 0) {
            if (object.equals(this.elementData[n2])) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public final synchronized Object elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " >= " + this.elementCount);
        }
        try {
            return this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " < 0");
        }
    }

    public final synchronized Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final synchronized Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final synchronized void setElementAt(Object object, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " >= " + this.elementCount);
        }
        this.elementData[n] = object;
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public final synchronized void insertElementAt(Object object, int n) {
        int n2 = this.elementCount + 1;
        if (n >= n2) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " > " + this.elementCount);
        }
        if (n2 > this.elementData.length) {
            this.ensureCapacityHelper(n2);
        }
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = object;
        ++this.elementCount;
    }

    public final synchronized void addElement(Object object) {
        int n = this.elementCount + 1;
        if (n > this.elementData.length) {
            this.ensureCapacityHelper(n);
        }
        this.elementData[this.elementCount++] = object;
    }

    public final synchronized boolean removeElement(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        int n = 0;
        while (n < this.elementCount) {
            this.elementData[n] = null;
            ++n;
        }
        this.elementCount = 0;
    }

    public synchronized Object clone() {
        try {
            Vector vector = (Vector)super.clone();
            vector.elementData = new Object[this.elementCount];
            System.arraycopy(this.elementData, 0, vector.elementData, 0, this.elementCount);
            return vector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.elements();
        stringBuffer.append("[");
        int n2 = 0;
        while (n2 <= n) {
            String string = enumeration.nextElement().toString();
            stringBuffer.append(string);
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

