/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.PrintStream;
import java.sql.DriverManager;

public class JdbcOdbcObject {
    protected static boolean isTracing() {
        return DriverManager.getLogStream() != null;
    }

    protected static void trace(String string) {
        PrintStream printStream = DriverManager.getLogStream();
        if (printStream != null) {
            printStream.println(string);
        }
    }

    protected static void trace(String string, boolean bl) {
        PrintStream printStream;
        if (bl) {
            JdbcOdbcObject.trace(string);
        }
        if ((printStream = DriverManager.getLogStream()) != null) {
            printStream.print(string);
        }
    }

    protected static void dumpByte(byte[] byArray, int n) {
        JdbcOdbcObject.trace("Dump (" + n + " bytes):");
        int n2 = 0;
        while (n2 * 16 < n) {
            String string = JdbcOdbcObject.toHex(n2 * 16);
            JdbcOdbcObject.trace(" " + JdbcOdbcObject.hexPad(string, 8) + "  ", false);
            String string2 = "";
            int n3 = 0;
            while (n3 < 16) {
                int n4 = n2 * 16 + n3;
                if (n4 >= n) {
                    string = "  ";
                    string2 = String.valueOf(string2) + " ";
                } else {
                    string = JdbcOdbcObject.toHex(byArray[n4]);
                    string = JdbcOdbcObject.hexPad(string, 2);
                    string2 = byArray[n4] < 32 || byArray[n4] > 128 ? String.valueOf(string2) + "." : String.valueOf(string2) + new String(byArray, 0, n4, 1);
                }
                JdbcOdbcObject.trace(String.valueOf(string) + " ", false);
                ++n3;
            }
            JdbcOdbcObject.trace("   " + string2);
            ++n2;
        }
    }

    public static String hexPad(String string, int n) {
        if (!string.startsWith("0x")) {
            return string;
        }
        String string2 = string.substring(2);
        int n2 = string2.length();
        if (n2 > n) {
            string2 = string2.substring(n2 - n);
        } else if (n2 < n) {
            String string3;
            String string4 = "0000000000000000";
            string2 = string3 = String.valueOf(string4.substring(0, n - n2)) + string2;
        }
        string2 = string2.toUpperCase();
        return string2;
    }

    public static String toHex(int n) {
        char[] cArray = new char[8];
        String string = "0123456789ABCDEF";
        int n2 = 0;
        while (n2 < 4) {
            byte by = (byte)(n & 0xFF);
            cArray[6 - n2 * 2] = string.charAt(by >> 4 & 0xF);
            cArray[7 - n2 * 2] = string.charAt(by & 0xF);
            n >>= 8;
            ++n2;
        }
        return "0x" + new String(cArray);
    }

    public static byte[] hexStringToByteArray(String string) throws NumberFormatException {
        int n = string.length();
        int n2 = (n + 1) / 2;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = (byte)JdbcOdbcObject.hexPairToInt(string.substring(n3 * 2, (n3 + 1) * 2));
            ++n3;
        }
        return byArray;
    }

    public static int hexPairToInt(String string) throws NumberFormatException {
        String string2 = "0123456789ABCDEF";
        String string3 = string.toUpperCase();
        int n = 0;
        int n2 = 0;
        int n3 = string3.length();
        if (n3 > 2) {
            n3 = 2;
        }
        int n4 = 0;
        while (n4 < n3) {
            n2 = string2.indexOf(string3.substring(n4, n4 + 1));
            if (n2 < 0) {
                throw new NumberFormatException();
            }
            if (n4 == 0) {
                n2 *= 16;
            }
            n += n2;
            ++n4;
        }
        return n;
    }
}

