/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import sun.misc.RegexpPool;
import sun.net.NetworkClient;
import sun.net.ProgressData;
import sun.net.ProgressEntry;
import sun.net.www.HeaderParser;
import sun.net.www.MessageHeader;
import sun.net.www.MeteredStream;
import sun.net.www.http.KeepAliveCache;
import sun.net.www.http.KeepAliveStream;

public class HttpClient
extends NetworkClient {
    MessageHeader requests;
    boolean failedOnce = false;
    KeepAliveStream kas;
    private static RegexpPool dontProxy = null;
    static final int httpPortNumber = 80;
    public static String proxyHost = null;
    public static int proxyPort = 80;
    public static boolean httpKeepAliveSet = true;
    private String instProxy;
    private int instProxyPort = -1;
    protected boolean proxyDisabled;
    public boolean usingProxy = false;
    private String host;
    private int port;
    protected static KeepAliveCache kac = new KeepAliveCache();
    boolean keepingAlive = false;
    int keepAliveConnections = -1;
    int keepAliveTimeout;
    protected URL url;

    protected int getDefaultPort() {
        return 80;
    }

    public static synchronized void resetProperties() {
        String string;
        proxyHost = System.getProperty("http.proxyHost");
        proxyPort = Integer.getInteger("http.proxyPort", 80);
        if (proxyHost == null) {
            proxyHost = System.getProperty("proxyHost");
            proxyPort = Integer.getInteger("proxyPort", 80);
        }
        if (proxyHost != null && proxyHost.length() == 0) {
            proxyHost = null;
        }
        if ((KeepAliveCache.MAXCONNS = Integer.getInteger("http.maxConnections", 2).intValue()) <= 0) {
            KeepAliveCache.MAXCONNS = 2;
        }
        if ((string = System.getProperty("http.keepAlive")) != null) {
            httpKeepAliveSet = Boolean.valueOf(string);
        }
        dontProxy = new RegexpPool();
        String string2 = System.getProperty("http.nonProxyHosts");
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|", false);
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    dontProxy.add(stringTokenizer.nextToken().toLowerCase(), new Boolean(true));
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    public HttpClient(URL uRL, String string, int n) throws IOException {
        this(uRL, string, n, false);
    }

    private HttpClient(URL uRL, String string, int n, boolean bl) throws IOException {
        this.proxyDisabled = bl;
        if (!bl) {
            this.instProxy = string;
            this.instProxyPort = n < 0 ? this.getDefaultPort() : n;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(uRL.getHost());
            this.host = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            this.host = uRL.getHost();
        }
        this.url = uRL;
        this.port = uRL.getPort();
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
        this.openServer();
    }

    protected HttpClient(URL uRL, boolean bl) throws IOException {
        this(uRL, null, -1, bl);
    }

    private HttpClient(URL uRL) throws IOException {
        this(uRL, null, -1, false);
    }

    public static HttpClient New(URL uRL) throws IOException {
        HttpClient httpClient = (HttpClient)kac.get(uRL);
        if (httpClient == null) {
            httpClient = new HttpClient(uRL);
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
            httpClient.url = uRL;
        }
        return httpClient;
    }

    public static void finished(HttpClient httpClient) {
        --httpClient.keepAliveConnections;
        if (httpClient.keepAliveConnections > 0 && httpClient.keepingAlive && !httpClient.serverOutput.checkError()) {
            kac.put(httpClient.url, httpClient);
            return;
        }
        httpClient.closeServer();
    }

    public void openServer(String string, int n) throws IOException {
        this.serverSocket = this.doConnect(string, n);
        this.serverOutput = new PrintStream(new BufferedOutputStream(this.serverSocket.getOutputStream()));
        this.serverSocket.setTcpNoDelay(true);
    }

    private synchronized void openServer() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.host, this.port);
        }
        if (this.keepingAlive) {
            return;
        }
        if (this.instProxy != null) {
            this.openServer(this.instProxy, this.instProxyPort);
            this.usingProxy = true;
            return;
        }
        if (this.proxyDisabled || dontProxy.match(this.url.getHost().toLowerCase()) != null || dontProxy.match(this.host) != null) {
            this.openServer(this.host, this.port);
            this.usingProxy = false;
            return;
        }
        if (this.url.getProtocol().equals("http")) {
            if (proxyHost != null) {
                try {
                    this.openServer(proxyHost, proxyPort);
                    this.instProxy = proxyHost;
                    this.instProxyPort = proxyPort;
                    this.usingProxy = true;
                    return;
                }
                catch (IOException iOException) {}
            }
            this.openServer(this.host, this.port);
            return;
        }
        if (this.instProxy != null) {
            try {
                super.openServer(this.instProxy, this.instProxyPort);
                this.usingProxy = true;
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
        if (proxyHost != null) {
            try {
                super.openServer(proxyHost, proxyPort);
                this.instProxy = proxyHost;
                this.instProxyPort = proxyPort;
                this.usingProxy = true;
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
        super.openServer(this.host, this.port);
    }

    public String getURLFile() throws IOException {
        String string = this.url.getFile();
        if (string == null || string.length() == 0) {
            string = "/";
        }
        if (this.usingProxy) {
            String string2 = String.valueOf(this.url.getProtocol()) + "://" + this.url.getHost();
            if (this.url.getPort() != -1) {
                string2 = String.valueOf(string2) + ":" + this.url.getPort();
            }
            string = String.valueOf(string2) + string;
        }
        if (string.indexOf(10) == -1) {
            return string;
        }
        throw new MalformedURLException("Illegal character in URL");
    }

    public void writeRequests(MessageHeader messageHeader) {
        this.requests = messageHeader;
        this.requests.print(this.serverOutput);
        this.serverOutput.flush();
    }

    public boolean parseHTTP(MessageHeader messageHeader, ProgressEntry progressEntry) throws IOException {
        int n;
        this.keepAliveConnections = -1;
        this.keepAliveTimeout = 0;
        boolean bl = false;
        byte[] byArray = new byte[7];
        try {
            this.serverInput = new PushbackInputStream(this.serverSocket.getInputStream(), 7);
            n = 0;
            while (n < 7) {
                int n2 = this.serverInput.read(byArray, n, 7 - n);
                if (n2 < 0) break;
                n += n2;
            }
            String string = null;
            bl = byArray[0] == 72 && byArray[1] == 84 && byArray[2] == 84 && byArray[3] == 80 && byArray[4] == 47 && byArray[5] == 49 && byArray[6] == 46;
            ((PushbackInputStream)this.serverInput).unread(byArray);
            if (bl) {
                messageHeader.parseHeader(this.serverInput);
                string = this.usingProxy ? messageHeader.findValue("Proxy-Connection") : messageHeader.findValue("Connection");
                if (string != null && string.toLowerCase().equals("keep-alive")) {
                    HeaderParser headerParser = new HeaderParser(messageHeader.findValue("Keep-Alive"));
                    this.keepAliveConnections = headerParser.findInt("max", 5);
                    this.keepAliveTimeout = headerParser.findInt("timeout", 5);
                }
            } else {
                if (n != 7) {
                    if (!this.failedOnce && this.requests != null) {
                        this.failedOnce = true;
                        this.closeServer();
                        this.openServer();
                        this.writeRequests(this.requests);
                        return this.parseHTTP(messageHeader, progressEntry);
                    }
                    throw new SocketException("Unexpected end of file from server");
                }
                messageHeader.set("Content-type", "unknown/unknown");
            }
        }
        catch (IOException iOException) {
            this.closeServer();
            if (!this.failedOnce && this.requests != null && !(iOException instanceof InterruptedIOException)) {
                this.failedOnce = true;
                this.openServer();
                this.writeRequests(this.requests);
                return this.parseHTTP(messageHeader, progressEntry);
            }
            throw iOException;
        }
        n = -1;
        try {
            n = Integer.parseInt(messageHeader.findValue("content-length"));
        }
        catch (Exception exception) {}
        if (this.keepAliveConnections > 1 && n > 0) {
            this.keepingAlive = true;
        } else if (this.keepingAlive) {
            this.keepingAlive = false;
        }
        if (n > 0) {
            progressEntry.setType(this.url.getFile(), messageHeader.findValue("content-type"));
            progressEntry.update(0, n);
            if (this.keepingAlive) {
                this.kas = new KeepAliveStream(this.serverSocket.getInputStream(), progressEntry, this);
                this.serverInput = new BufferedInputStream(this.kas);
                this.failedOnce = false;
            } else {
                this.serverInput = new BufferedInputStream(new MeteredStream(this.serverSocket.getInputStream(), progressEntry));
            }
        } else {
            this.serverInput = new BufferedInputStream(this.serverSocket.getInputStream());
            ProgressData.pdata.unregister(progressEntry);
        }
        return bl;
    }

    public synchronized InputStream getInputStream() {
        return this.serverInput;
    }

    public OutputStream getOutputStream() {
        return this.serverOutput;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.url + ")";
    }

    public final boolean isKeepingAlive() {
        return httpKeepAliveSet && this.keepingAlive;
    }

    protected void finalize() throws Throwable {
    }

    public void closeServer() {
        try {
            this.keepingAlive = false;
            this.serverSocket.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public String getProxyHostUsed() {
        if (!this.usingProxy) {
            return null;
        }
        return this.instProxy;
    }

    public int getProxyPortUsed() {
        return this.instProxyPort;
    }

    static {
        HttpClient.resetProperties();
    }
}

