/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sun.misc.BASE64Decoder;
import sun.net.www.MessageHeader;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.ParsingException;
import sun.security.pkcs.SignerInfo;
import sun.security.provider.SystemIdentity;
import sun.security.x509.X509Cert;
import sun.tools.jar.JarEntryVerifier;
import sun.tools.jar.JarException;
import sun.tools.jar.Manifest;
import sun.tools.jar.SignatureFile;

public class JarVerifierStream
extends ZipInputStream {
    private static final boolean debug = false;
    private ZipEntry currentEntry;
    private Hashtable signatures;
    private Hashtable verifiedIdentities;
    private Hashtable sigFileIdentities;
    private boolean parsingBlock = false;
    private boolean parsingMeta = true;
    private boolean parsingManifest = false;
    private boolean processed = false;
    private Manifest manifest;
    private ByteArrayOutputStream baos;
    JarEntryVerifier jev = new JarEntryVerifier();
    private IdentityScope scope;
    private static final char[] hexc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public JarVerifierStream(InputStream inputStream) throws IOException, JarException {
        super(inputStream);
        this.signatures = new Hashtable();
        this.sigFileIdentities = new Hashtable();
        this.verifiedIdentities = new Hashtable();
        this.baos = new ByteArrayOutputStream();
        this.scope = IdentityScope.getSystemScope();
    }

    public synchronized ZipEntry getNextEntry() throws IOException {
        if (this.currentEntry != null) {
            this.closeEntry();
        }
        this.currentEntry = super.getNextEntry();
        if (this.currentEntry == null) {
            return null;
        }
        this.processed = false;
        String string = this.currentEntry.getName();
        String string2 = string.toUpperCase();
        if (this.parsingMeta && this.manifest == null && Manifest.isManifestName(string2)) {
            this.parsingManifest = true;
            this.baos.reset();
            this.jev.setEntry(null, null);
            return this.currentEntry;
        }
        if (this.parsingMeta && (string2.startsWith("META-INF/") || string2.startsWith("/META-INF/") || string2.startsWith("META-INF\\") || string2.startsWith("\\META-INF\\") || string2.startsWith("/META-INF\\") || string2.startsWith("\\META-INF/"))) {
            if (string2.endsWith(".DSA") || string2.endsWith(".RSA")) {
                this.parsingBlock = true;
                this.baos.reset();
                this.jev.setEntry(null, null);
            }
            return this.currentEntry;
        }
        if (this.parsingMeta) {
            this.parsingMeta = false;
        }
        if (this.currentEntry.isDirectory()) {
            this.jev.setEntry(null, null);
            return this.currentEntry;
        }
        if (string.startsWith("./")) {
            string = string.substring(2);
        }
        if (this.sigFileIdentities.get(string) != null) {
            this.jev.setEntry(this.manifest, string);
            return this.currentEntry;
        }
        this.jev.setEntry(null, null);
        return this.currentEntry;
    }

    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            if (this.parsingBlock || this.parsingManifest) {
                this.baos.write(n);
            } else {
                this.jev.update((byte)n);
            }
        } else {
            this.processEntry();
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            if (this.parsingBlock || this.parsingManifest) {
                this.baos.write(byArray, n, n3);
            } else {
                this.jev.update(byArray, n, n3);
            }
        } else {
            this.processEntry();
        }
        return n3;
    }

    private void processEntry() throws IOException {
        if (this.processed) {
            return;
        }
        this.processed = true;
        if (this.parsingManifest) {
            this.parsingManifest = false;
            this.manifest = new Manifest(this.baos.toByteArray());
            return;
        }
        if (this.parsingBlock) {
            this.parsingBlock = false;
            try {
                PKCS7 pKCS7 = new PKCS7(this.baos.toByteArray());
                byte[] byArray = pKCS7.getContentInfo().getData();
                SignatureFile signatureFile = new SignatureFile(byArray);
                this.signatures.put(signatureFile, pKCS7);
                this.processSignature(signatureFile, pKCS7);
                return;
            }
            catch (ParsingException parsingException) {
                return;
            }
            catch (IOException iOException) {
                return;
            }
            catch (SignatureException signatureException) {
                return;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return;
            }
        }
        this.jev.verify(this.verifiedIdentities, this.sigFileIdentities);
    }

    private void processSignature(SignatureFile signatureFile, PKCS7 pKCS7) throws JarException, SignatureException, NoSuchAlgorithmException {
        Vector vector = null;
        if (this.manifest == null) {
            return;
        }
        SignerInfo[] signerInfoArray = pKCS7.verify();
        if (signerInfoArray == null) {
            return;
        }
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        MessageDigest messageDigest2 = MessageDigest.getInstance("MD5");
        vector = this.getIdentities(signerInfoArray, pKCS7);
        Enumeration enumeration = signatureFile.entries();
        while (enumeration.hasMoreElements()) {
            MessageHeader messageHeader;
            MessageHeader messageHeader2 = (MessageHeader)enumeration.nextElement();
            String string = messageHeader2.findValue("Name");
            if (string == null || (messageHeader = this.manifest.getEntry(string)) == null) continue;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            messageHeader.print(printStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            boolean bl = this.verifySigFileEntry(messageHeader2, "SHA-Digest", byArray, messageDigest, bASE64Decoder, string);
            boolean bl2 = this.verifySigFileEntry(messageHeader2, "MD5-Digest", byArray, messageDigest2, bASE64Decoder, string);
            if (!bl && !bl2) continue;
            this.addIdentities(string, vector);
        }
    }

    private boolean verifySigFileEntry(MessageHeader messageHeader, String string, byte[] byArray, MessageDigest messageDigest, BASE64Decoder bASE64Decoder, String string2) throws JarException {
        byte[] byArray2;
        String string3 = messageHeader.findValue(string);
        if (string3 == null) {
            return false;
        }
        try {
            byArray2 = bASE64Decoder.decodeBuffer(string3);
        }
        catch (IOException iOException) {
            throw new SecurityException("unable to decode base64 digest");
        }
        messageDigest.reset();
        byte[] byArray3 = messageDigest.digest(byArray);
        if (!MessageDigest.isEqual(byArray3, byArray2)) {
            throw new SecurityException("invalid " + messageDigest.getAlgorithm() + " signature file digest for " + string2);
        }
        return true;
    }

    private Vector getIdentities(SignerInfo[] signerInfoArray, PKCS7 pKCS7) {
        Vector vector = null;
        if (this.scope == null) {
            return null;
        }
        int n = 0;
        while (n < signerInfoArray.length) {
            SignerInfo signerInfo = signerInfoArray[n];
            X509Cert x509Cert = signerInfo.getCertificate(pKCS7);
            PublicKey publicKey = x509Cert.getPublicKey();
            Identity identity = this.scope.getIdentity(publicKey);
            if (identity == null) {
                try {
                    String string = x509Cert.getPrincipal().getName();
                    identity = new SystemIdentity(string, this.scope);
                    identity.setPublicKey(publicKey);
                    identity.addCertificate(x509Cert);
                }
                catch (KeyManagementException keyManagementException) {}
            }
            if (identity != null) {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement(identity);
            }
            ++n;
        }
        return vector;
    }

    private void addIdentities(String string, Vector vector) {
        Vector vector2;
        if (vector == null) {
            return;
        }
        if (string.startsWith("./")) {
            string = string.substring(2);
        }
        if ((vector2 = (Vector)this.sigFileIdentities.get(string)) == null) {
            vector2 = new Vector();
            this.sigFileIdentities.put(string, vector2);
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            vector2.addElement(object);
        }
    }

    public Hashtable getVerifiedSignatures() {
        return this.verifiedIdentities;
    }

    public Enumeration getBlocks() {
        return this.signatures.elements();
    }

    public Hashtable getNameToHash() {
        return null;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public Identity[] getIdentities(String string) {
        Vector vector = (Vector)this.verifiedIdentities.get(string);
        if (vector == null) {
            return null;
        }
        Object[] objectArray = new Identity[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(hexc[byArray[n] >> 4 & 0xF]);
            stringBuffer.append(hexc[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }
}

