/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class DevIO
extends Thread
implements SerialPortEventListener {
    static CommPortIdentifier portId;
    static Enumeration portList;
    boolean debug = false;
    int error;
    String errorMsg = "";
    int X;
    int x;
    int version;
    public String devName = "unknown";
    public int device = -1;
    int bytesRead;
    int readPtr;
    private byte[] readBuffer = new byte[255];
    boolean newRxData = false;
    InputStream inputStream;
    SerialPort serialPort;
    OutputStream outputStream;

    public DevIO(String string) {
        try {
            portId = CommPortIdentifier.getPortIdentifier((String)string);
        }
        catch (NoSuchPortException noSuchPortException) {
            this.error = 6;
            this.errorMsg = noSuchPortException.toString();
            return;
        }
        try {
            this.serialPort = (SerialPort)portId.open("F100", 2000);
        }
        catch (PortInUseException portInUseException) {
            this.error = 1;
            return;
        }
        try {
            this.inputStream = this.serialPort.getInputStream();
        }
        catch (IOException iOException) {
            this.error = 2;
            return;
        }
        try {
            this.serialPort.addEventListener((SerialPortEventListener)this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            this.error = 3;
            return;
        }
        this.serialPort.notifyOnDataAvailable(true);
        try {
            this.serialPort.setSerialPortParams(19200, 8, 1, 0);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            this.error = 4;
            return;
        }
        try {
            this.outputStream = this.serialPort.getOutputStream();
            return;
        }
        catch (IOException iOException) {
            this.error = 5;
            return;
        }
    }

    public boolean reset() {
        int[] nArray = new int[11];
        nArray[10] = 116;
        int[] nArray2 = nArray;
        int n = this.writeDevice(nArray2);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {}
        byte[] byArray = new byte[255];
        this.readDevice(byArray, 255);
        return n == 0;
    }

    public boolean readID() {
        this.X = 0;
        this.x = 0;
        this.devName = "unknown";
        this.reset();
        int[] nArray = new int[]{120};
        byte[] byArray = new byte[255];
        this.readDevice(byArray, 255);
        int n = this.writeDevice(nArray);
        if (n != 0) {
            return false;
        }
        int n2 = 0;
        do {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
            if (++n2 <= 20) continue;
            return false;
        } while (!this.newRxData);
        if (this.readDevice(byArray, 11) != 11) {
            return false;
        }
        this.version = byArray[6] - 48;
        this.X = byArray[8] - 48;
        this.x = byArray[10] - 48;
        this.device = 0;
        if (this.X == 0) {
            this.devName = "F105";
        } else if (this.X == 1) {
            this.devName = "F150/155";
        }
        if (byArray[6] == 49) {
            this.devName = "F105";
            this.device = 1;
        } else if (byArray[6] == 50) {
            this.devName = "F150";
            this.device = 2;
        } else if (byArray[6] == 51) {
            this.devName = "F155";
            this.device = 3;
        } else if (byArray[6] == 52) {
            this.devName = "F160";
            this.device = 4;
        }
        return true;
    }

    public int writeDevice(int[] nArray) {
        if (this.outputStream == null) {
            return 0;
        }
        try {
            int n = 0;
            while (n < nArray.length) {
                if (this.debug) {
                    System.err.print(String.valueOf(nArray[n]) + ",");
                }
                this.outputStream.write(nArray[n]);
                ++n;
            }
        }
        catch (IOException iOException) {
            this.errorMsg = iOException.toString();
            return 1;
        }
        if (this.debug) {
            System.err.println(" ");
        }
        return 0;
    }

    public int readDevice(byte[] byArray, int n) {
        if (!this.newRxData) {
            return 0;
        }
        if (n > this.bytesRead) {
            n = this.bytesRead;
        }
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = this.readBuffer[n2];
            ++n2;
        }
        int n3 = this.bytesRead;
        this.newRxData = false;
        this.bytesRead = 0;
        this.readPtr = 0;
        return n3;
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(20000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void serialEvent(SerialPortEvent serialPortEvent) {
        switch (serialPortEvent.getEventType()) {
            case 1: {
                try {
                    int n;
                    while ((n = this.inputStream.available()) > 0) {
                        this.bytesRead += this.inputStream.read(this.readBuffer, this.readPtr, n);
                    }
                    if (this.debug) {
                        System.err.println("RX " + this.bytesRead + ":" + new String(this.readBuffer, 0, this.bytesRead));
                    }
                }
                catch (IOException iOException) {
                    System.err.println(iOException.toString());
                }
                this.newRxData = true;
                return;
            }
        }
    }
}

