/*
 * Decompiled with CFR 0.152.
 */
import Serialio.SerialConfig;
import Serialio.SerialPortLocal;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class f100 {
    boolean packFrame = false;
    public FGen fg;
    public DevIO dIO;
    public Properties props;
    public String port;
    public String fileName = "";
    public String syncFileName = "";
    public boolean runNow = false;

    public f100(String[] stringArray) {
        if (stringArray.length > 0) {
            if (stringArray[0].equals("-b")) {
                if (stringArray.length == 2) {
                    this.fileName = stringArray[1];
                    this.runBatch();
                    return;
                }
                this.usage();
                return;
            }
            if (stringArray[0].equals("-r") && stringArray.length == 2) {
                this.fileName = stringArray[1];
                this.runNow = true;
                this.runGUI();
                return;
            }
            if (stringArray[0].equals("-s") && stringArray.length == 3) {
                this.syncFileName = stringArray[1];
                this.fileName = stringArray[2];
                this.runSync();
                return;
            }
            this.fileName = stringArray[0];
            this.runGUI();
            return;
        }
        this.runGUI();
    }

    public static void main(String[] stringArray) {
        new f100(stringArray);
    }

    public void usage() {
        new ErrorMsg("Missing program file name: f100c file", null);
    }

    public void runBatch() {
        FileIO fileIO;
        String string;
        if (!this.init(null, null)) {
            System.exit(0);
        }
        if ((string = (fileIO = new FileIO()).readFile(this.fileName)).length() > 0) {
            FGen fGen = new FGen(this.dIO, null, string);
            fGen.start();
        }
    }

    public void runSync() {
        if (!this.init(null, null)) {
            System.exit(0);
        }
        FileIO fileIO = new FileIO();
        File file = null;
        file = new File(this.syncFileName);
        String string = fileIO.readFile(this.fileName);
        if (string.length() > 0) {
            FGen fGen = new FGen(this.dIO, null, string);
            while (!file.exists()) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
            }
            fGen.start();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean init(Frame frame, MessageDialog messageDialog) {
        MessageDialog messageDialog2;
        FileIO fileIO = new FileIO(messageDialog);
        this.props = fileIO.loadProperties("f100.cfg");
        this.port = this.props.getProperty("port", "");
        if (this.port.length() < 1 && frame != null && messageDialog != null) {
            messageDialog2 = new MessageDialog(frame, "Device port", "Device port is not defined", "You will be prompted for the port.");
            messageDialog2.validate();
            messageDialog2.show();
            this.port = null;
            PropertiesDialog propertiesDialog = new PropertiesDialog(frame, this.port);
            propertiesDialog.validate();
            propertiesDialog.show();
            if (!propertiesDialog.ok) {
                new ErrorMsg("Device port needs to be defined", "Exiting application", messageDialog);
                messageDialog.validate();
                messageDialog.show();
                return false;
            }
            this.port = propertiesDialog.ports.getSelectedItem();
            if (this.props != null) {
                ((Hashtable)this.props).put("port", this.port);
                fileIO.saveProperties("f100.cfg", this.props);
            }
        } else if (this.port.length() < 1 && (frame == null || messageDialog == null)) {
            new ErrorMsg("Device port needs to be defined in file f100.cfg", "  Ex: port=COM1", null);
            return false;
        }
        this.dIO = new DevIO(this.port);
        if (this.dIO.error == 6) {
            new ErrorMsg("Communication port does not exist", "Rerun F100 and select a different port", messageDialog);
            System.err.println(this.dIO.errorMsg);
            if (this.props != null) {
                ((Hashtable)this.props).remove("port");
                fileIO.saveProperties("f100.cfg", this.props);
            }
            return false;
        }
        if (this.dIO.error == 1) {
            new ErrorMsg("Communication port is in use", "Close other applications first", messageDialog);
            System.err.println(this.dIO.errorMsg);
            if (this.props != null) {
                ((Hashtable)this.props).remove("port");
                fileIO.saveProperties("f100.cfg", this.props);
            }
            return false;
        }
        if (this.dIO.error != 0) {
            new ErrorMsg("Error initializing device communication", messageDialog);
            System.err.println(this.dIO.errorMsg);
            return false;
        }
        if (!this.dIO.reset()) {
            new ErrorMsg("Error reseting device", messageDialog);
            return false;
        }
        if (this.dIO.readID()) {
            return true;
        }
        if (frame != null) {
            messageDialog2 = new MessageDialog(frame, "Error", "Can't find device!", "Check cable connection and software properties");
            messageDialog2.validate();
            messageDialog2.show();
        }
        new ErrorMsg("Can't find device!", "Check cable connection and software properties", null);
        return true;
    }

    public void runGUI() {
        Frame1 frame1 = new Frame1(this);
        if (this.packFrame) {
            frame1.pack();
            return;
        }
        frame1.validate();
    }

    public static void testSerialPort() {
        String string = "COM1";
        try {
            SerialConfig serialConfig = new SerialConfig(string);
            serialConfig.setBitRate(8);
            serialConfig.setDataBits(3);
            serialConfig.setStopBits(0);
            serialConfig.setParity(0);
            serialConfig.setHandshake(2);
            SerialPortLocal serialPortLocal = new SerialPortLocal(serialConfig);
            serialPortLocal.setDTR(true);
            serialPortLocal.putString("x");
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return;
        }
    }

    public static void simul() {
        System.out.println("f100 simulation");
        int n = 6170000;
        int n2 = 0x1000000;
        double d = 0.5;
        int n3 = (int)d * n2;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 1;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (true) {
            if ((n4 += n) > n2 - 1) {
                ++n10;
                if (n6 != n8 || n7 != n9) {
                    System.out.println(String.valueOf(n10 - n5) + ":  " + (n8 - n6) + " " + (n9 - n7));
                    n5 = n10;
                }
                n8 = n6;
                n9 = n7;
                n7 = 0;
                n6 = 0;
                n4 -= n2;
            }
            if (n4 < n3) {
                ++n6;
                continue;
            }
            ++n7;
        }
    }
}

