/*
 * Decompiled with CFR 0.152.
 */
package waba.sys;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import waba.applet.Applet;
import waba.applet.JavaBridge;
import waba.applet.WinCanvas;
import waba.io.ByteArrayStream;
import waba.io.Catalog;
import waba.io.DataStream;
import waba.sys.NativeMethods;
import waba.sys.Time;
import waba.sys.Vm;
import waba.ui.MainWindow;

public class NativeMethods4JDK
extends NativeMethods {
    static double[] rounds = new double[]{0.5, 0.05, 0.005, 5.0E-4, 5.0E-5, 5.0E-6, 5.0E-7, 5.0E-8, 5.0E-9, 5.0E-10, 5.0E-11, 5.0E-12, 5.0E-13, 5.0E-14, 5.0E-15, 5.0E-16, 5.0E-17, 5.0E-18};
    private static final long POSITIVE_INFINITY_VALUE = 0x7FF0000000000000L;
    private static final long NEGATIVE_INFINITY_VALUE = -4503599627370496L;
    private static final char negSign = '-';
    private static final char plusSign = '+';
    private static final char decimalPoint = '.';
    private static final byte EXP_NOTATION = 16;
    private static final byte NO_EXP_NOTATION = 32;
    private static final double LN10 = 2.3025850929940455;
    private static final double MAX_FLOAT = 1.152921504606847E18;
    private static final double MIN_FLOAT = 8.881784197001252E-16;
    private static final String Infinity = "Inf";
    private static final String NaN = "NaN";
    private static final int MAX_DECIMALS = 15;
    private static ClipboardOwner defaultClipboardOwner = new ClipboardObserver();

    public NativeMethods4JDK() {
        if (Applet.currentApplet == null) {
            new Applet();
        }
    }

    int convertToInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {}
        return n;
    }

    String convertToString(char c) {
        return String.valueOf(c);
    }

    int convertToIntBitwise(float f) {
        return Float.floatToIntBits(f);
    }

    float convertToFloatBitwise(int n) {
        return Float.intBitsToFloat(n);
    }

    String convertToString(float f) {
        return Float.toString(f);
    }

    String convertToString(int n) {
        return Integer.toString(n);
    }

    private static long bits(double d) {
        return Double.doubleToLongBits(d);
    }

    private static String reverse(StringBuffer stringBuffer) {
        char[] cArray = stringBuffer.toString().toCharArray();
        char[] cArray2 = new char[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            cArray2[cArray.length - 1 - n] = cArray[n];
            ++n;
        }
        stringBuffer.setLength(0);
        return new String(cArray2);
    }

    private static void doubleToStr(StringBuffer stringBuffer, double d, int n, int n2, int n3) {
        int n4;
        boolean bl;
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d *= -1.0;
        }
        if (Double.isNaN(d)) {
            stringBuffer.append(NaN);
            return;
        }
        if (NativeMethods4JDK.bits(d) == 0x7FF0000000000000L || NativeMethods4JDK.bits(d) == -4503599627370496L) {
            stringBuffer.append(bl ? (char)'-' : '+');
            stringBuffer.append(Infinity);
            return;
        }
        if (d != 0.0 && (d >= 1.152921504606847E18 || d <= 8.881784197001252E-16 || (n3 & 0x10) != 0) && (n3 & 0x20) == 0) {
            double d2;
            boolean bl3;
            double d3 = Math.log(d) / 2.3025850929940455;
            boolean bl4 = bl3 = d3 < 0.0;
            if (bl3) {
                d3 *= -1.0;
            }
            if (bl3) {
                d2 = 1.0 - (d3 - (double)((long)d3));
                d3 = 1L + (long)d3;
                if (d2 >= 1.0) {
                    d2 -= 1.0;
                    d3 -= 1.0;
                }
            } else {
                d2 = d3 - (double)((long)d3);
                d3 = (long)d3;
            }
            d2 = Math.pow(10.0, d2);
            if (bl) {
                d2 *= -1.0;
            }
            if (n == 0) {
                NativeMethods4JDK.doubleToStr(stringBuffer, d2, 0, n2, n3 | 0x20);
            } else {
                NativeMethods4JDK.doubleToStr(stringBuffer, d2, 1, 0, n3 | 0x20);
            }
            stringBuffer.append('e');
            stringBuffer.append(bl3 ? (char)'-' : '+');
            stringBuffer.append(String.valueOf((int)d3));
            return;
        }
        boolean bl5 = n2 < 0;
        long l = (long)d;
        double d4 = d - (double)l;
        if (d4 != 0.0) {
            if (bl5) {
                double d5 = d4;
                n4 = 1;
                while (n4 <= 15) {
                    if ((d5 *= 10.0) >= 1.0) {
                        n2 = n4;
                    }
                    d5 -= (double)((long)d5);
                    ++n4;
                }
                if (n2 == 15) {
                    d5 = d4 += rounds[15];
                    n4 = 1;
                    while (n4 <= 15) {
                        if ((d5 *= 10.0) >= 1.0) {
                            n2 = n4;
                        }
                        d5 -= (double)((long)d5);
                        ++n4;
                    }
                }
            }
            if (n2 > 15) {
                n2 = 15;
            }
            if ((d4 += rounds[n2]) > 1.0) {
                l += (long)d4;
                d4 -= 1.0;
            }
        }
        do {
            n4 = (int)(l % 10L);
            stringBuffer.append((char)(48 + n4));
        } while ((l /= 10L) > 0L);
        String string = NativeMethods4JDK.reverse(stringBuffer);
        if (bl) {
            stringBuffer.append('-');
        }
        stringBuffer.append(string);
        if (n2 > 0) {
            stringBuffer.append('.');
            while (n2-- > 0) {
                n4 = (int)(d4 *= 10.0) % 10;
                stringBuffer.append((char)(48 + n4));
                d4 -= (double)n4;
            }
            if (bl5) {
                char[] cArray = stringBuffer.toString().toCharArray();
                n4 = cArray.length;
                while (cArray[n4 - 1] == '0') {
                    --n4;
                }
                if (cArray[n4 - 1] == '.' && n4 != cArray.length) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(cArray);
                }
            }
        }
    }

    String convertToString(double d, int n) {
        StringBuffer stringBuffer = new StringBuffer(40);
        NativeMethods4JDK.doubleToStr(stringBuffer, d, 0, n, 0);
        return stringBuffer.toString();
    }

    double convertToDouble(String string) {
        try {
            double d = Double.valueOf(string);
            return d;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    String convertToString(float f, int n) {
        return this.convertToString((double)f, n);
    }

    float convertToFloat(String string) {
        try {
            return Float.valueOf(string).floatValue();
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    String convertToString(String string, int n) {
        return this.convertToString(this.convertToDouble(string), n);
    }

    long convertDoubleToLongBits(double d) {
        return Double.doubleToLongBits(d);
    }

    double convertDoubleFromLongBits(long l) {
        return Double.longBitsToDouble(l);
    }

    void timeCreate(Time time) {
        JavaBridge.fillTime(time);
    }

    boolean vmCopyArray(Object object, int n, Object object2, int n2, int n3) {
        if (n3 < 0) {
            return false;
        }
        try {
            System.arraycopy(object, n, object2, n2, n3);
        }
        catch (Exception exception) {
            Vm.debug("Exception thrown in vmCopyArray: " + exception.getMessage());
            return false;
        }
        return true;
    }

    int vmGetTimeStamp() {
        return (int)(System.currentTimeMillis() % 0x40000000L);
    }

    int vmExec(String string, String string2, int n, boolean bl) {
        int n2 = -1;
        try {
            if (n == -1) {
                Class<?> clazz = Class.forName(string);
                Applet.currentApplet.commandLine = string2;
                Applet.currentApplet.destroyCurrentMainWindow();
                Applet.currentApplet.mainWindow = (MainWindow)clazz.newInstance();
                Applet.currentApplet.mainWindow.onStart();
                n2 = 0;
            } else {
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec(String.valueOf(string) + " " + string2);
                n2 = bl ? process.waitFor() : 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n2;
    }

    int vmSetDeviceAutoOff(int n) {
        return 0;
    }

    void vmSleep(int n) {
        try {
            Thread.currentThread();
            Thread.sleep(n);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    void vmGC() {
        Runtime.getRuntime().gc();
    }

    int vmGetDeviceFreeMemory() {
        return (int)Runtime.getRuntime().freeMemory();
    }

    void vmInterceptSystemKeys(int n) {
    }

    int vmGetSystemKeysPressed() {
        return WinCanvas.currentCanvas.currentKeysState;
    }

    void vmDebug(String string) {
        JavaBridge.print(String.valueOf(System.currentTimeMillis()) + " - " + string);
    }

    void vmSetTrace(boolean bl) {
        Runtime.getRuntime().traceMethodCalls(bl);
    }

    void vmClipboardCopy(String string) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, defaultClipboardOwner);
    }

    String vmClipboardPaste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(defaultClipboardOwner);
        if (transferable != null) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                return string;
            }
            catch (Exception exception) {
                return "";
            }
        }
        return "";
    }

    boolean vmAttachLibrary(String string) {
        Catalog catalog;
        boolean bl = false;
        if (string.indexOf(46) == -1) {
            Vm.debug("NOTE: in desktop, you must use Vm.attachLibrary(\"name.CRTR\"), otherwise the library will not be found");
            return false;
        }
        File file = new File(".", String.valueOf((string = String.valueOf(string) + ".SWAX").substring(0, string.indexOf(46))) + ".pdb");
        if (file.canRead() && (catalog = new Catalog(string, 1)).isOpen()) {
            int n = catalog.getRecordCount();
            int n2 = 0;
            while (n2 < n) {
                catalog.setRecordPos(n2);
                DataStream dataStream = new DataStream(catalog);
                String string2 = dataStream.readString();
                if (string2.endsWith(".bmp")) {
                    int n3 = catalog.getRecordSize() - string2.length() - 2;
                    ByteArrayStream byteArrayStream = new ByteArrayStream(n3);
                    catalog.readBytes(byteArrayStream.getBuffer(), 0, n3);
                    waba.fx.NativeMethods4JDK.htAttachedBitmaps.put(string2, byteArrayStream);
                    Vm.debug("Image found in library: " + string2);
                    bl = true;
                }
                ++n2;
            }
        }
        return bl;
    }

    boolean vmAttachNativeLibrary(String string) {
        this.vmDebug("attachNativeLibrary impossible in JDK");
        return false;
    }

    static class ClipboardObserver
    implements ClipboardOwner {
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }

        ClipboardObserver() {
        }
    }
}

