/*
 * Decompiled with CFR 0.152.
 */
package waba.util;

import waba.util.Vector;

public final class Hashtable {
    private Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public Hashtable(int n) {
        this(n, 0.75f);
    }

    public Hashtable(int n, float f) {
        if (n <= 0) {
            n = 5;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public void clear() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    public Object get(Object object) {
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.table.length;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Vector getKeys() {
        Vector vector = new Vector(this.size());
        if (this.table != null) {
            int n = this.table.length;
            Entry entry = null;
            int n2 = 0;
            while (n2 < n) {
                entry = this.table[n2];
                if (entry != null) {
                    vector.add(entry.key);
                    while (entry.next != null) {
                        entry = entry.next;
                        vector.add(entry.key);
                    }
                }
                ++n2;
            }
        }
        return vector;
    }

    public Object put(Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                Object object3 = entry.value;
                entry.value = object2;
                return object3;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(object, object2);
        }
        Entry entry2 = new Entry();
        entry2.hash = n;
        entry2.key = object;
        entry2.value = object2;
        entry2.next = entryArray[n2];
        entryArray[n2] = entry2;
        ++this.count;
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = ((n << 1) + n >> 1) + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public Object remove(Object object) {
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    private class Entry {
        int hash;
        Object key;
        Object value;
        Entry next;

        Entry() {
            Hashtable.this = Hashtable.this;
        }
    }
}

