/*
 * Decompiled with CFR 0.152.
 */
package waba.util;

import waba.sys.Convert;
import waba.sys.Vm;

public final class Vector {
    public Object[] items;
    private int count;

    public Vector() {
        this(8);
    }

    public Vector(int n) {
        this.items = new Object[n == 0 ? 1 : n];
    }

    public Vector(Object[] objectArray) {
        if (objectArray != null) {
            this.items = objectArray;
            this.count = objectArray.length;
            return;
        }
        this.items = new Object[1];
    }

    public void add(Object object) {
        if (this.count < this.items.length) {
            this.items[this.count++] = object;
            return;
        }
        this.insert(this.count, object);
    }

    public void insert(int n, Object object) {
        if (n < 0 || n > this.count) {
            n = this.count;
        }
        if (this.count == this.items.length) {
            Object[] objectArray = new Object[this.items.length * 12 / 10 + 1];
            Vm.copyArray(this.items, 0, objectArray, 0, this.count);
            this.items = objectArray;
        }
        if (n != this.count) {
            Vm.copyArray(this.items, n, this.items, n + 1, this.count - n);
        }
        this.items[n] = object;
        ++this.count;
    }

    public void del(int n) {
        if (n != this.count - 1) {
            Vm.copyArray(this.items, n + 1, this.items, n, this.count - n - 1);
        }
        this.items[this.count - 1] = null;
        --this.count;
    }

    public boolean del(Object object) {
        int n = this.find(object);
        if (n >= 0) {
            this.del(n);
            return true;
        }
        return false;
    }

    public Object get(int n) {
        if (n >= this.count) {
            n = this.items.length;
        }
        return this.items[n];
    }

    public void set(int n, Object object) {
        if (n >= this.count) {
            n = this.items.length;
        }
        this.items[n] = object;
    }

    public int find(Object object) {
        return this.find(object, 0);
    }

    public int find(Object object, int n) {
        int n2 = n;
        while (n2 < this.count) {
            if (this.items[n2].equals(object)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getCount() {
        return this.count;
    }

    public Object[] toObjectArray() {
        if (this.count == 0) {
            return null;
        }
        Object[] objectArray = this.items[0] instanceof String ? new String[this.count] : new Object[this.count];
        if (this.count > 0) {
            Vm.copyArray(this.items, 0, objectArray, 0, this.count);
        }
        return objectArray;
    }

    public void push(Object object) {
        this.add(object);
    }

    public Object pop() {
        Object object = null;
        if (this.count > 0) {
            object = this.items[--this.count];
        }
        this.items[this.count] = null;
        return object;
    }

    public Object peek() {
        if (this.count > 0) {
            return this.items[this.count - 1];
        }
        return null;
    }

    public void clear() {
        int n = 0;
        while (n < this.count) {
            this.items[n] = null;
            ++n;
        }
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public int indexOf(Object object) {
        return this.find(object, 0);
    }

    public int indexOf(Object object, int n) {
        return this.find(object, n);
    }

    public Object elementAt(int n) {
        return this.get(n);
    }

    public void setElementAt(Object object, int n) {
        this.set(n, object);
    }

    public void removeElementAt(int n) {
        this.del(n);
    }

    public void insertElementAt(Object object, int n) {
        this.insert(n, object);
    }

    public void addElement(Object object) {
        this.add(object);
    }

    public boolean removeElement(Object object) {
        return this.del(object);
    }

    public void removeAllElements() {
        this.clear();
    }

    public boolean qsort() {
        if (this.count > 0) {
            Convert.qsort(this.items, 0, this.count - 1);
            return true;
        }
        return false;
    }
}

